/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.carrotsearch.hppc;

import cdjd.com.carrotsearch.hppc.BitMixer;
import cdjd.com.carrotsearch.hppc.HashOrderMixing;
import cdjd.com.carrotsearch.hppc.LongShortHashMap;

public class LongShortScatterMap
extends LongShortHashMap {
    public LongShortScatterMap() {
        this(4);
    }

    public LongShortScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public LongShortScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(long key) {
        return BitMixer.mixPhi(key);
    }

    public static LongShortScatterMap from(long[] keys, short[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongShortScatterMap map = new LongShortScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

