/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.carrotsearch.hppc;

import cdjd.com.carrotsearch.hppc.ArraySizingStrategy;
import cdjd.com.carrotsearch.hppc.IntArrayList;
import cdjd.com.carrotsearch.hppc.IntContainer;
import cdjd.com.carrotsearch.hppc.cursors.IntCursor;

public class IntStack
extends IntArrayList {
    public IntStack() {
    }

    public IntStack(int expectedElements) {
        super(expectedElements);
    }

    public IntStack(int expectedElements, ArraySizingStrategy resizer) {
        super(expectedElements, resizer);
    }

    public IntStack(IntContainer container) {
        super(container);
    }

    public void push(int e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void push(int e1, int e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void push(int e1, int e2, int e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public void push(int e1, int e2, int e3, int e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public void push(int[] elements, int start, int len) {
        assert (start >= 0 && len >= 0);
        this.ensureBufferSpace(len);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, len);
        this.elementsCount += len;
    }

    public final void push(int ... elements) {
        this.push(elements, 0, elements.length);
    }

    public int pushAll(IntContainer container) {
        return this.addAll(container);
    }

    public int pushAll(Iterable<? extends IntCursor> iterable) {
        return this.addAll(iterable);
    }

    public void discard(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
    }

    public void discard() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public int pop() {
        assert (this.elementsCount > 0);
        int v = this.buffer[--this.elementsCount];
        return v;
    }

    public int peek() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    public static IntStack from(int ... elements) {
        IntStack stack = new IntStack(elements.length);
        stack.push(elements);
        return stack;
    }

    @Override
    public IntStack clone() {
        return (IntStack)super.clone();
    }
}

