/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.carrotsearch.hppc;

import cdjd.com.carrotsearch.hppc.BitMixer;
import cdjd.com.carrotsearch.hppc.HashOrderMixing;
import cdjd.com.carrotsearch.hppc.IntFloatHashMap;

public class IntFloatScatterMap
extends IntFloatHashMap {
    public IntFloatScatterMap() {
        this(4);
    }

    public IntFloatScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public IntFloatScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(int key) {
        return BitMixer.mixPhi(key);
    }

    public static IntFloatScatterMap from(int[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntFloatScatterMap map = new IntFloatScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

