/*
 * Decompiled with CFR 0.152.
 */
package bpm.excel.oda.runtime.impl;

import bpm.excel.oda.runtime.impl.Driver;
import bpm.excel.oda.runtime.impl.Query;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import jxl.Cell;
import jxl.CellType;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultSetMetaData
implements IResultSetMetaData {
    private Query query;
    private Workbook workbookin;
    private HashMap<Integer, Integer> columnsType = new HashMap();

    public ResultSetMetaData(Query query) throws Exception {
        this.query = query;
        try {
            FileInputStream is = new FileInputStream(query.getFilePath());
            WorkbookSettings set = new WorkbookSettings();
            set.setInitialFileSize(((InputStream)is).available());
            this.workbookin = Workbook.getWorkbook((InputStream)is, (WorkbookSettings)set);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Exception("Unable to find file - " + e.getMessage(), e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception("Unable to read file - " + e.getMessage(), e);
        }
        catch (BiffException e) {
            e.printStackTrace();
            throw new Exception("Unable to parse file - " + e.getMessage(), e);
        }
    }

    public int getColumnCount() throws OdaException {
        return this.query.getColumnIds().size();
    }

    public String getColumnName(int index) throws OdaException {
        if (this.workbookin == null) {
            throw new OdaException("null workbook");
        }
        Sheet sheet = this.workbookin.getSheet(this.query.getSheetName());
        Cell cell = sheet.getCell(this.query.getColumnIds().get(index - 1).intValue(), 0);
        return cell.getContents();
    }

    public String getColumnLabel(int index) throws OdaException {
        if (this.workbookin == null) {
            throw new OdaException("null workbook");
        }
        Sheet sheet = this.workbookin.getSheet(this.query.getSheetName());
        Cell cell = sheet.getCell(this.query.getColumnIds().get(index - 1).intValue(), 0);
        return cell.getContents();
    }

    public int getColumnType(int index) throws OdaException {
        if (this.workbookin == null) {
            throw new OdaException("null workbook");
        }
        index = this.query.getColumnIds().get(index - 1);
        if (this.columnsType.get(index) == null) {
            Sheet sheet = this.workbookin.getSheet(this.query.getSheetName());
            CellType xlsType = null;
            int max = sheet.getRows();
            int i = 1;
            while (i < max) {
                if (!sheet.getCell(index, i).getContents().equalsIgnoreCase("")) {
                    xlsType = sheet.getCell(index, i).getType();
                    if (sheet.getCell(index, i).getContents().equalsIgnoreCase("") && xlsType == CellType.NUMBER) {
                        this.columnsType.put(index, 3);
                    } else if (sheet.getCell(index, i).getType() != xlsType && !sheet.getCell(index, i).getContents().equalsIgnoreCase("")) {
                        throw new OdaException("Differents data's types are present in col number " + index);
                    }
                }
                ++i;
            }
            if (this.columnsType.get(index) == null) {
                if (xlsType == CellType.DATE) {
                    this.columnsType.put(index, 91);
                } else if (xlsType == CellType.NUMBER) {
                    this.columnsType.put(index, 8);
                } else if (xlsType == CellType.LABEL) {
                    this.columnsType.put(index, 1);
                } else {
                    this.columnsType.put(index, 1);
                }
            }
        }
        return this.columnsType.get(index);
    }

    public String getColumnTypeName(int index) throws OdaException {
        int nativeTypeCode = this.getColumnType(index);
        return Driver.getNativeDataTypeName(nativeTypeCode);
    }

    public int getColumnDisplayLength(int index) throws OdaException {
        index = this.query.getColumnIds().get(index - 1);
        return this.workbookin.getSheet(this.query.getSheetName()).getCell(index, 0).getContents().length();
    }

    public int getPrecision(int index) throws OdaException {
        return -1;
    }

    public int getScale(int index) throws OdaException {
        return -1;
    }

    public int isNullable(int index) throws OdaException {
        return 2;
    }

    public int getMaxRow() {
        int res = 0;
        Sheet[] sheetArray = this.workbookin.getSheets();
        int n = sheetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Sheet s = sheetArray[n2];
            res = Math.max(res, s.getRows());
            ++n2;
        }
        return res - 1;
    }

    public void close() {
        this.workbookin.close();
        this.workbookin = null;
    }
}

