/*
 * Decompiled with CFR 0.152.
 */
package bpm.excel.oda.runtime.impl;

import bpm.excel.oda.runtime.impl.Query;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import jxl.Cell;
import jxl.DateCell;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultSet
implements IResultSet {
    private int m_maxRows = 0;
    private int m_currentRowId;
    private Query query;
    private Workbook workbookin;
    private String error;

    public ResultSet(Query query) {
        this.query = query;
        try {
            FileInputStream is = new FileInputStream(query.getFilePath());
            WorkbookSettings set = new WorkbookSettings();
            set.setInitialFileSize(((InputStream)is).available());
            this.workbookin = Workbook.getWorkbook((InputStream)is, (WorkbookSettings)set);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.error = e.getMessage();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.error = e.getMessage();
        }
        catch (BiffException e) {
            e.printStackTrace();
            this.error = e.getMessage();
        }
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return this.query.getMetaData();
    }

    public void setMaxRows(int max) throws OdaException {
        this.m_maxRows = max;
    }

    protected int getMaxRows() {
        return this.m_maxRows;
    }

    public boolean next() throws OdaException {
        Sheet sheet = this.workbookin.getSheet(this.query.getSheetName());
        if (this.m_currentRowId >= sheet.getRows() - 1) {
            return false;
        }
        int maxRows = this.getMaxRows();
        if (this.m_currentRowId < maxRows) {
            ++this.m_currentRowId;
            return true;
        }
        return false;
    }

    public void close() throws OdaException {
        try {
            this.workbookin.close();
            this.query.close();
        }
        catch (Exception exception) {}
        this.workbookin = null;
        this.query = null;
        this.m_currentRowId = 0;
    }

    public int getRow() throws OdaException {
        return this.m_currentRowId;
    }

    public String getString(int index) throws OdaException {
        if (this.workbookin == null) {
            throw new OdaException(this.error);
        }
        index = this.query.getColumnIds().get(index - 1);
        Sheet sheet = this.workbookin.getSheet(this.query.getSheetName());
        Cell cell = sheet.getCell(index, this.getRow());
        return cell.getContents();
    }

    public String getString(String columnName) throws OdaException {
        return this.getString(this.findColumn(columnName));
    }

    public int getInt(int index) throws OdaException {
        if (this.workbookin == null) {
            throw new OdaException(this.error);
        }
        index = this.query.getColumnIds().get(index - 1);
        Sheet sheet = this.workbookin.getSheet(this.query.getSheetName());
        Cell cell = sheet.getCell(index, this.getRow());
        try {
            int res = new Integer(cell.getContents());
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OdaException(e.getMessage());
        }
    }

    public int getInt(String columnName) throws OdaException {
        return this.getInt(this.findColumn(columnName));
    }

    public double getDouble(int index) throws OdaException {
        if (this.workbookin == null) {
            throw new OdaException(this.error);
        }
        index = this.query.getColumnIds().get(index - 1);
        Sheet sheet = this.workbookin.getSheet(this.query.getSheetName());
        Cell cell = sheet.getCell(index, this.getRow());
        try {
            Double res = new Double(cell.getContents());
            return res;
        }
        catch (Exception e) {
            try {
                return new Double(((NumberCell)cell).getValue());
            }
            catch (Exception _e) {
                _e.printStackTrace();
                throw new OdaException(String.valueOf(e.getMessage()) + " for cellcontents" + cell.getContents());
            }
        }
    }

    public double getDouble(String columnName) throws OdaException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        if (this.workbookin == null) {
            throw new OdaException(this.error);
        }
        index = this.query.getColumnIds().get(index - 1);
        Sheet sheet = this.workbookin.getSheet(this.query.getSheetName());
        Cell cell = sheet.getCell(index, this.getRow());
        try {
            BigDecimal res = new BigDecimal(cell.getContents());
            return res;
        }
        catch (Exception exception) {
            try {
                return new BigDecimal(((NumberCell)cell).getValue());
            }
            catch (Exception _e) {
                _e.printStackTrace();
                return null;
            }
        }
    }

    public BigDecimal getBigDecimal(String columnName) throws OdaException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public Date getDate(int index) throws OdaException {
        if (this.workbookin == null) {
            throw new OdaException(this.error);
        }
        index = this.query.getColumnIds().get(index - 1);
        Sheet sheet = this.workbookin.getSheet(this.query.getSheetName());
        Cell cell = sheet.getCell(index, this.getRow());
        try {
            DateFormat df = ((DateCell)cell).getDateFormat();
            java.util.Date date = df.parse(cell.getContents());
            return new Date(date.getTime());
        }
        catch (Exception e) {
            throw new OdaException(e.getMessage());
        }
    }

    public Date getDate(String columnName) throws OdaException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(int index) throws OdaException {
        if (this.workbookin == null) {
            throw new OdaException(this.error);
        }
        index = this.query.getColumnIds().get(index - 1);
        Sheet sheet = this.workbookin.getSheet(this.query.getSheetName());
        Cell cell = sheet.getCell(index, this.getRow());
        try {
            Time res = Time.valueOf(cell.getContents());
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OdaException(e.getMessage());
        }
    }

    public Time getTime(String columnName) throws OdaException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        if (this.workbookin == null) {
            throw new OdaException(this.error);
        }
        index = this.query.getColumnIds().get(index - 1);
        Sheet sheet = this.workbookin.getSheet(this.query.getSheetName());
        Cell cell = sheet.getCell(index, this.getRow());
        try {
            Timestamp res = Timestamp.valueOf(cell.getContents());
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OdaException(e.getMessage());
        }
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public IBlob getBlob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IBlob getBlob(String columnName) throws OdaException {
        return this.getBlob(this.findColumn(columnName));
    }

    public IClob getClob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(String columnName) throws OdaException {
        return this.getClob(this.findColumn(columnName));
    }

    public boolean getBoolean(int index) throws OdaException {
        if (this.workbookin == null) {
            throw new OdaException(this.error);
        }
        Sheet sheet = this.workbookin.getSheet(this.query.getSheetName());
        Cell cell = sheet.getCell(index, this.getRow());
        try {
            Boolean res = new Boolean(cell.getContents());
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OdaException(e.getMessage());
        }
    }

    public boolean getBoolean(String columnName) throws OdaException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public Object getObject(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String columnName) throws OdaException {
        return this.getObject(this.findColumn(columnName));
    }

    public boolean wasNull() throws OdaException {
        return false;
    }

    public int findColumn(String columnName) throws OdaException {
        int columnId = 1;
        if (columnName == null || columnName.length() == 0) {
            return columnId;
        }
        Sheet sheet = this.workbookin.getSheet(this.query.getSheetName());
        Cell c = sheet.findCell(columnName);
        if (c == null) {
            throw new OdaException("No column with name " + columnName + " has beeen found");
        }
        int index = 0;
        for (Integer i : this.query.getColumnIds()) {
            ++index;
            if (i.intValue() != c.getColumn()) continue;
            return index;
        }
        return index;
    }
}

