/*
 * Decompiled with CFR 0.152.
 */
package bpm.excel.oda.runtime.impl;

import bpm.excel.oda.runtime.impl.ParameterMetaData;
import bpm.excel.oda.runtime.impl.ResultSet;
import bpm.excel.oda.runtime.impl.ResultSetMetaData;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;

public class Query
implements IQuery {
    private int m_maxRows = 0;
    private IResultSetMetaData metadadata = null;
    private String m_preparedText;
    private String filePath;
    private String sheetName;
    private List<Integer> columnIds = new ArrayList<Integer>();
    private String dataSetType;

    public Query(String filePath) {
        this.filePath = filePath;
    }

    public void prepare(String queryText) throws OdaException {
        try {
            this.m_preparedText = queryText;
            Document doc = DocumentHelper.parseText((String)queryText);
            Element root = doc.getRootElement();
            this.sheetName = root.element("sheet").getText();
            Element cells = root.element("cells");
            for (Object o : cells.elements("cell")) {
                Element e = (Element)o;
                this.columnIds.add(new Integer(e.getStringValue()));
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new OdaException(e.getMessage());
        }
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
        this.filePath = null;
        this.sheetName = null;
        this.columnIds = null;
        this.metadadata = null;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        if (this.metadadata == null) {
            try {
                this.metadadata = new ResultSetMetaData(this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new OdaException((Throwable)ex);
            }
        }
        return this.metadadata;
    }

    public IResultSet executeQuery() throws OdaException {
        ResultSet resultSet = new ResultSet(this);
        resultSet.setMaxRows(this.getMaxRows());
        return resultSet;
    }

    public void setProperty(String name, String value) throws OdaException {
    }

    public void setMaxRows(int max) throws OdaException {
        this.m_maxRows = max;
    }

    public int getMaxRows() throws OdaException {
        if (this.m_maxRows == 0) {
            this.m_maxRows = ((ResultSetMetaData)this.getMetaData()).getMaxRow();
        }
        return this.m_maxRows;
    }

    public void clearInParameters() throws OdaException {
    }

    public void setInt(String parameterName, int value) throws OdaException {
    }

    public void setInt(int parameterId, int value) throws OdaException {
    }

    public void setDouble(String parameterName, double value) throws OdaException {
    }

    public void setDouble(int parameterId, double value) throws OdaException {
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
    }

    public void setString(String parameterName, String value) throws OdaException {
    }

    public void setString(int parameterId, String value) throws OdaException {
    }

    public void setDate(String parameterName, Date value) throws OdaException {
    }

    public void setDate(int parameterId, Date value) throws OdaException {
    }

    public void setTime(String parameterName, Time value) throws OdaException {
    }

    public void setTime(int parameterId, Time value) throws OdaException {
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
    }

    public void setObject(String parameterName, Object value) throws OdaException {
    }

    public void setObject(int parameterId, Object value) throws OdaException {
    }

    public void setNull(String parameterName) throws OdaException {
    }

    public void setNull(int parameterId) throws OdaException {
    }

    public int findInParameter(String parameterName) throws OdaException {
        return 0;
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        return new ParameterMetaData();
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec() throws OdaException {
        return null;
    }

    public void setSpecification(QuerySpecification querySpec) throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public QuerySpecification getSpecification() {
        return null;
    }

    public String getEffectiveQueryText() {
        return this.m_preparedText;
    }

    public void cancel() throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public List<Integer> getColumnIds() {
        return this.columnIds;
    }

    public String getFilePath() {
        return this.filePath;
    }
}

