/*
 * Decompiled with CFR 0.152.
 */
package bpm.excel.oda.runtime.impl;

import bpm.excel.oda.runtime.Activator;
import bpm.excel.oda.runtime.impl.DataSetMetaData;
import bpm.excel.oda.runtime.impl.Query;
import bpm.vanilla.platform.core.IRepositoryContext;
import bpm.vanilla.platform.core.IVanillaContext;
import bpm.vanilla.platform.core.beans.Group;
import bpm.vanilla.platform.core.beans.Repository;
import bpm.vanilla.platform.core.impl.BaseRepositoryContext;
import bpm.vanilla.platform.core.impl.BaseVanillaContext;
import bpm.vanilla.platform.core.remote.RemoteRepositoryApi;
import bpm.vanilla.platform.core.remote.RemoteVanillaPlatform;
import bpm.vanilla.platform.core.repository.RepositoryItem;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class Connection
implements IConnection {
    public static final String REPOSITORY_ID = "repository.id";
    public static final String USER = "repository.user";
    public static final String PASSWORD = "repository.password";
    public static final String DIRECTORY_ITEM_ID = "repository.item.id";
    public static final String GROUP_ID = "vanilla.group.id";
    public static final String STORAGE_TYPE = "storageType";
    public static final String FILE_NAME = "fileName";
    public static final String ENCODING = "encoding";
    protected boolean m_isOpen = false;
    private String path;

    public void open(Properties connProperties) throws OdaException {
        String vanillaUrl = Activator.getDefault().getVanillaUrl();
        BaseVanillaContext vCtx = new BaseVanillaContext(vanillaUrl, connProperties.getProperty(USER), connProperties.getProperty(PASSWORD));
        RemoteVanillaPlatform vanillaApi = new RemoteVanillaPlatform((IVanillaContext)vCtx);
        try {
            Repository def = vanillaApi.getVanillaRepositoryManager().getRepositoryById(new Integer(connProperties.getProperty(REPOSITORY_ID)).intValue());
            Group group = vanillaApi.getVanillaSecurityManager().getGroupById(new Integer(connProperties.getProperty(GROUP_ID)).intValue());
            RemoteRepositoryApi sock = new RemoteRepositoryApi((IRepositoryContext)new BaseRepositoryContext((IVanillaContext)vCtx, group, def));
            RepositoryItem item = sock.getRepositoryService().getDirectoryItem(new Integer(connProperties.getProperty(DIRECTORY_ITEM_ID)).intValue());
            this.path = System.getProperty("java.io.tmpdir");
            if (!this.path.endsWith(File.separator)) {
                this.path = String.valueOf(this.path) + File.separator;
            }
            this.path = String.valueOf(this.path) + "temp_van_" + new Object().hashCode() + ".xls";
            FileOutputStream fos = new FileOutputStream(this.path);
            sock.getDocumentationService().importExternalDocument(item, (OutputStream)fos);
            this.m_isOpen = true;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            this.m_isOpen = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_isOpen = false;
        }
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
        this.m_isOpen = false;
    }

    public boolean isOpen() throws OdaException {
        return this.m_isOpen;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        return new DataSetMetaData(this);
    }

    public IQuery newQuery(String dataSetType) throws OdaException {
        if (!this.isOpen()) {
            throw new OdaException("Cannot create query on closed connection");
        }
        return new Query(this.path);
    }

    public int getMaxQueries() throws OdaException {
        return 0;
    }

    public void commit() throws OdaException {
    }

    public void rollback() throws OdaException {
    }

    public void setLocale(ULocale locale) throws OdaException {
    }

    public String getTemporaryFile() {
        return this.path;
    }

    protected void setTemporaryFileName(String path) {
        this.path = path;
    }
}

