/*
 * Decompiled with CFR 0.152.
 */
package bpm.excel.oda.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    private String vanillaUrl = "";
    public static final String VANILLA_SERVER_URL = "bpm.vanilla.server.url";
    public static final String PLUGIN_ID = "bpm.excel.oda.runtime";
    private static Activator plugin;
    private static Logger logger;

    public void start(BundleContext context) throws Exception {
        File f;
        logger = Logger.getLogger((String)context.getBundle().getSymbolicName());
        super.start(context);
        plugin = this;
        if (System.getProperty("bpm.vanilla.configurationFile") != null) {
            logger.info((Object)("Loading configuration File = " + System.getProperty("bpm.vanilla.configurationFile")));
            f = new File(System.getProperty("bpm.vanilla.configurationFile"));
            if (!f.exists()) {
                logger.warn((Object)("The file " + System.getProperty("bpm.vanilla.configurationFile") + " does not exist."));
            } else {
                this.findVanillaUrl(f);
            }
        }
        if (this.vanillaUrl == null) {
            logger.warn((Object)"The property bpm.vanilla.server.url has not be found");
            f = new File(String.valueOf(Platform.getInstallLocation().getURL().getPath()) + File.separator + "resources" + File.separator);
            logger.info((Object)("Looking the property in .properties file located at : " + f.getAbsolutePath()));
            this.findVanillaUrl(f);
        }
        if (this.vanillaUrl == null) {
            throw new Exception("Cannot be started without bpm.vanilla.server.url property set within specified bpm.vanilla.configurationFile or [Palteform]/resources/*.properties files");
        }
    }

    private void findVanillaUrl(File f) {
        if (!f.isDirectory()) {
            if (f.exists() && f.getAbsolutePath().endsWith("properties")) {
                Properties p = new Properties();
                try {
                    p.load(new FileInputStream(f));
                    if (p.getProperty(VANILLA_SERVER_URL) != null) {
                        this.vanillaUrl = p.getProperty(VANILLA_SERVER_URL);
                        return;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File _f = fileArray[n2];
                this.findVanillaUrl(_f);
                ++n2;
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public String getVanillaUrl() {
        return this.vanillaUrl;
    }
}

