/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.iamsupport.plugin;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.util.IOUtils;
import com.simba.athena.amazonaws.util.StringUtils;
import com.simba.athena.iamsupport.model.CredentialsHolder;
import com.simba.athena.iamsupport.plugin.SamlCredentialsProvider;
import com.simba.athena.iamsupport.plugin.utils.LogUtils;
import com.simba.athena.shaded.fasterxml.jackson.databind.JsonNode;
import com.simba.athena.shaded.fasterxml.jackson.databind.ObjectMapper;
import com.simba.athena.support.LogUtilities;
import java.awt.Desktop;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import javax.swing.JOptionPane;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class OktaCredentialsProvider
extends SamlCredentialsProvider {
    private static final String KEY_APP_URL = "app_id";
    private static final String KEY_APP_NAME = "app_name";
    private static final String OKTA_MFA_TYPE = "okta_mfa_type";
    private static final String OKTA_MFA_WAIT_TIME = "okta_mfa_wait_time";
    private static final String OKTA_PHONE_NUMBER = "okta_phone_number";
    private static final String OKTA_VERIFY_PUSH_FACTOR_TYPE = "push";
    private static final String OKTA_VERIFY_TOTP_FACTOR_TYPE = "token:software:totp";
    private static final String OKTA_SMS_FACTOR_TYPE = "sms";
    private static final String OKTA_VERIFY_PROVIDER = "OKTA";
    private static final String GOOGLE_AUTHENTICATOR_FACTOR_TYPE = "token:software:totp";
    private static final String GOOGLE_AUTHENTICATOR_PROVIDER = "GOOGLE";
    private static final int DEFAULT_OKTA_MFA_WAIT_TIME = 60;
    private static final String OKTA_AUTHENTICATION_URL = "/api/v1/authn";
    private static final String OKTA_FACTORS_URL = "/api/v1/authn/factors";
    public static final String USE_OKTA_MFA = "UseOktaMFA";
    protected String m_app_id;
    protected String m_app_name;
    protected String m_okta_mfa_type;
    protected String m_okta_phone_number;
    protected int m_okta_mfa_wait_time = 60;
    private String m_oktaMfaFactorType;
    private String m_oktaMfaProvider;
    private boolean m_useOktaMfa = false;

    @Override
    public void addParameter(String string, String string2) {
        super.addParameter(string, string2);
        if (KEY_APP_URL.equalsIgnoreCase(string)) {
            this.m_app_id = string2;
        }
        if (KEY_APP_NAME.equalsIgnoreCase(string)) {
            this.m_app_name = string2;
        }
        if (OKTA_MFA_TYPE.equalsIgnoreCase(string)) {
            this.m_okta_mfa_type = string2;
        }
        if (OKTA_MFA_WAIT_TIME.equalsIgnoreCase(string)) {
            this.m_okta_mfa_wait_time = Integer.parseInt(string2);
        }
        if (OKTA_PHONE_NUMBER.equalsIgnoreCase(string)) {
            this.m_okta_phone_number = string2;
        }
        if (USE_OKTA_MFA.equalsIgnoreCase(string)) {
            this.m_useOktaMfa = Boolean.parseBoolean(string2);
        }
    }

    @Override
    protected String getSamlAssertion() throws IOException {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        this.checkRequiredParameters();
        if (StringUtils.isNullOrEmpty(this.m_app_id)) {
            throw new IOException("Missing required property: app_id");
        }
        CloseableHttpClient closeableHttpClient = null;
        try {
            Object object;
            closeableHttpClient = this.getHttpClient();
            if (null != this.m_proxyHost && !this.m_proxyHost.isEmpty() && this.m_useProxyForIdpAuth.booleanValue() && this.m_proxyUid != null && !this.m_proxyUid.isEmpty() && this.m_proxyPwd != null && !this.m_proxyPwd.isEmpty()) {
                object = new BasicCredentialsProvider();
                object.setCredentials(new AuthScope(this.m_proxyHost, this.m_proxyPort), new UsernamePasswordCredentials(this.m_proxyUid, this.m_proxyPwd));
                closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)object).build();
            }
            object = this.oktaAuthentication(closeableHttpClient);
            LogUtilities.logDebug("Exiting", LogUtils.getLogger());
            String string = this.handleSamlAssertion(closeableHttpClient, (String)object);
            return string;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SdkClientException("Failed create SSLContext.", generalSecurityException);
        }
        finally {
            IOUtils.closeQuietly(closeableHttpClient, null);
        }
    }

    @Override
    protected CredentialsHolder performPostSAMLAction(String string, String string2, CredentialsHolder credentialsHolder) throws SdkClientException {
        LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string), LogUtils.getLogger());
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return null;
    }

    private String handleSamlAssertion(CloseableHttpClient closeableHttpClient, String string) throws IOException {
        int n;
        Object object;
        LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string), LogUtils.getLogger());
        this.m_app_name = StringUtils.isNullOrEmpty(this.m_app_name) ? "amazon_aws" : URLEncoder.encode(this.m_app_name, "UTF-8");
        String string2 = "https://" + this.m_idpHost + "/home/" + this.m_app_name + "/" + this.m_app_id;
        String string3 = string2 + "?onetimetoken=" + string;
        this.validateURL(string3);
        HttpGet httpGet = new HttpGet(string3);
        if (null != this.m_proxyHost && !this.m_proxyHost.isEmpty() && this.m_useProxyForIdpAuth.booleanValue()) {
            object = new HttpHost(this.m_proxyHost, this.m_proxyPort);
            RequestConfig requestConfig = RequestConfig.custom().setProxy((HttpHost)object).build();
            httpGet.setConfig(requestConfig);
        }
        if ((n = (object = closeableHttpClient.execute(httpGet)).getStatusLine().getStatusCode()) != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + object.getStatusLine().getStatusCode() + " : Reason : " + object.getStatusLine().getReasonPhrase());
        }
        String string4 = EntityUtils.toString(object.getEntity());
        for (String string5 : this.getInputTagsfromHTML(string4)) {
            String string6 = this.getValueByKey(string5, "name");
            String string7 = this.getValueByKey(string5, "value");
            if (!"SAMLResponse".equalsIgnoreCase(string6)) continue;
            LogUtilities.logDebug("Exiting", LogUtils.getLogger());
            return string7.replace("&#x2b;", "+").replace("&#x3d;", "=");
        }
        throw new IOException("Failed to retrieve SAMLAssertion.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String oktaAuthentication(CloseableHttpClient closeableHttpClient) throws IOException {
        block17: {
            JsonNode jsonNode;
            CloseableHttpResponse closeableHttpResponse;
            block16: {
                block15: {
                    String string;
                    LogUtilities.logDebug("Entered", LogUtils.getLogger());
                    closeableHttpResponse = null;
                    try {
                        int n;
                        Object object;
                        ObjectMapper objectMapper = new ObjectMapper();
                        String string2 = "https://" + this.m_idpHost + OKTA_AUTHENTICATION_URL;
                        this.validateURL(string2);
                        HttpPost httpPost = new HttpPost(string2);
                        httpPost.addHeader("Accept", "application/json");
                        httpPost.addHeader("Content-Type", "application/json");
                        httpPost.addHeader("Cache-Control", "no-cache");
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("username", this.m_userName);
                        hashMap.put("password", this.m_password);
                        StringWriter stringWriter = new StringWriter();
                        objectMapper.writeValue(stringWriter, hashMap);
                        StringEntity stringEntity = new StringEntity(stringWriter.toString(), "UTF-8");
                        stringEntity.setContentType("application/json");
                        httpPost.setEntity(stringEntity);
                        if (null != this.m_proxyHost && !this.m_proxyHost.isEmpty() && this.m_useProxyForIdpAuth.booleanValue()) {
                            if (this.m_proxyUid != null && !this.m_proxyUid.isEmpty() && this.m_proxyPwd != null && !this.m_proxyPwd.isEmpty()) {
                                object = new BasicCredentialsProvider();
                                object.setCredentials(new AuthScope(this.m_proxyHost, this.m_proxyPort), new UsernamePasswordCredentials(this.m_proxyUid, this.m_proxyPwd));
                                closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)object).setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).build();
                            }
                            object = new HttpHost(this.m_proxyHost, this.m_proxyPort);
                            RequestConfig requestConfig = RequestConfig.custom().setProxy((HttpHost)object).build();
                            httpPost.setConfig(requestConfig);
                        }
                        if ((n = (object = (closeableHttpResponse = closeableHttpClient.execute(httpPost)).getStatusLine()).getStatusCode()) != 200) {
                            throw new IOException(object.getReasonPhrase());
                        }
                        jsonNode = objectMapper.readTree(EntityUtils.toString(closeableHttpResponse.getEntity()));
                        if (!"SUCCESS".equals(jsonNode.get("status").asText())) break block15;
                        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
                        string = jsonNode.get("sessionToken").asText();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(closeableHttpResponse, null);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(closeableHttpResponse, null);
                    return string;
                }
                if (!this.m_useOktaMfa) throw new IOException("No session token in the response.");
                if (20 > this.m_okta_mfa_wait_time) {
                    throw new IOException("Wait time cannot be less than 20 seconds");
                }
                if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.OKTAVERIFYWITHPUSH.toString())) {
                    this.m_oktaMfaFactorType = OKTA_VERIFY_PUSH_FACTOR_TYPE;
                    this.m_oktaMfaProvider = OKTA_VERIFY_PROVIDER;
                } else if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.OKTAVERIFYWITHTOTP.toString())) {
                    this.m_oktaMfaFactorType = "token:software:totp";
                    this.m_oktaMfaProvider = OKTA_VERIFY_PROVIDER;
                } else if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.GOOGLEAUTHENTICATOR.toString())) {
                    this.m_oktaMfaFactorType = "token:software:totp";
                    this.m_oktaMfaProvider = GOOGLE_AUTHENTICATOR_PROVIDER;
                } else {
                    if (!this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.SMSAUTHENTICATION.toString())) throw new IOException("Invalid factor type specified.");
                    this.m_oktaMfaFactorType = OKTA_SMS_FACTOR_TYPE;
                    this.m_oktaMfaProvider = OKTA_VERIFY_PROVIDER;
                }
                if (!"MFA_REQUIRED".equals(jsonNode.get("status").asText())) break block16;
                LogUtilities.logDebug("Exiting", LogUtils.getLogger());
                String string = this.authenticateExistingUser(closeableHttpClient, jsonNode);
                IOUtils.closeQuietly(closeableHttpResponse, null);
                return string;
            }
            if (!"MFA_ENROLL".equals(jsonNode.get("status").asText())) throw new IOException("No session token in the response.");
            String string = this.enrollNewUser(closeableHttpClient, jsonNode);
            if (!string.equals("SUCCESS")) break block17;
            LogUtilities.logDebug("Exiting", LogUtils.getLogger());
            String string3 = this.oktaAuthentication(closeableHttpClient);
            IOUtils.closeQuietly(closeableHttpResponse, null);
            return string3;
        }
        throw new IOException("Okta MFA Enrollment Failed.");
    }

    private String authenticateExistingUser(CloseableHttpClient closeableHttpClient, JsonNode jsonNode) throws IOException {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        JsonNode jsonNode2 = jsonNode.path("_embedded").path("factors");
        for (JsonNode jsonNode3 : jsonNode2) {
            String string;
            String string2 = jsonNode3.path("factorType").asText();
            String string3 = jsonNode3.path("provider").asText();
            if (!string2.equalsIgnoreCase(this.m_oktaMfaFactorType) || !string3.equalsIgnoreCase(this.m_oktaMfaProvider)) continue;
            if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.OKTAVERIFYWITHPUSH.toString())) {
                String string4 = jsonNode3.path("_links").path("verify").path("href").asText();
                int n = 0;
                int n2 = this.m_okta_mfa_wait_time / 10;
                while (n2 > n) {
                    try {
                        String string5 = this.getOktaVerifyState(closeableHttpClient, jsonNode.get("stateToken").asText(), string4);
                        if ("WAITING".equals(string5)) {
                            ++n;
                            Thread.sleep(10000L);
                            continue;
                        }
                        if ("REJECTED".equals(string5)) {
                            throw new IOException("Okta Verify Push Notification Rejected.");
                        }
                        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
                        return string5;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                throw new IOException("Failed Maximum number of retries");
            }
            if (!this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.OKTAVERIFYWITHTOTP.toString()) && !this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.GOOGLEAUTHENTICATOR.toString()) && !this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.SMSAUTHENTICATION.toString())) continue;
            String string6 = jsonNode3.path("_links").path("verify").path("href").asText();
            if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.SMSAUTHENTICATION.toString())) {
                this.sendSMSChallenge(closeableHttpClient, jsonNode.get("stateToken").asText(), string6);
            }
            if (null != (string = JOptionPane.showInputDialog("Please enter passcode to authenticate: "))) {
                LogUtilities.logDebug("Exiting", LogUtils.getLogger());
                return this.verifyTotpFactor(closeableHttpClient, jsonNode.get("stateToken").asText(), string6, string);
            }
            throw new IOException("User cancelled the authentication process");
        }
        throw new IOException("Enrollment Failed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSMSChallenge(CloseableHttpClient closeableHttpClient, String string, String string2) throws IOException {
        LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string), LogUtils.getLogger());
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            Object object;
            Object object2;
            ObjectMapper objectMapper = new ObjectMapper();
            boolean bl = false;
            HttpPost httpPost = new HttpPost(string2);
            String string3 = string2.substring(8, string2.indexOf("/", 8));
            httpPost.addHeader("Accept", "application/json");
            httpPost.addHeader("Content-Type", "application/json");
            httpPost.addHeader("Cache-Control", "no-cache");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("stateToken", string);
            StringWriter stringWriter = new StringWriter();
            objectMapper.writeValue(stringWriter, hashMap);
            StringEntity stringEntity = new StringEntity(stringWriter.toString(), "UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity(stringEntity);
            if (!(null == this.m_proxyHost || this.m_proxyHost.isEmpty() || !this.m_useProxyForIdpAuth.booleanValue() || (bl = this.CheckNonProxyHost(string3, this.m_nonProxyHosts)) || this.m_proxyUid == null || this.m_proxyUid.isEmpty() || this.m_proxyPwd == null || this.m_proxyPwd.isEmpty())) {
                object2 = new BasicCredentialsProvider();
                object2.setCredentials(new AuthScope(this.m_proxyHost, this.m_proxyPort), new UsernamePasswordCredentials(this.m_proxyUid, this.m_proxyPwd));
                closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)object2).setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).build();
                HttpHost httpHost = new HttpHost(this.m_proxyHost, this.m_proxyPort);
                object = RequestConfig.custom().setProxy(httpHost).build();
                httpPost.setConfig((RequestConfig)object);
            }
            closeableHttpResponse = closeableHttpClient.execute(httpPost);
            object2 = closeableHttpResponse.getStatusLine();
            int n = object2.getStatusCode();
            object = objectMapper.readTree(EntityUtils.toString(closeableHttpResponse.getEntity()));
            if (n == 403 || n == 401) {
                throw new IOException(((JsonNode)object).get("errorSummary").asText());
            }
            if (n != 200) {
                throw new IOException(object2.getReasonPhrase());
            }
            if (!"MFA_CHALLENGE".equals(((JsonNode)object).get("status").asText())) {
                throw new IOException("SMS Challenge failed.");
            }
        }
        catch (Throwable throwable) {
            LogUtilities.logDebug("Exiting", LogUtils.getLogger());
            IOUtils.closeQuietly(closeableHttpResponse, null);
            throw throwable;
        }
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        IOUtils.closeQuietly(closeableHttpResponse, null);
    }

    private String enrollNewUser(CloseableHttpClient closeableHttpClient, JsonNode jsonNode) throws IOException {
        block9: {
            String string;
            LogUtilities.logDebug("Entered", LogUtils.getLogger());
            CloseableHttpResponse closeableHttpResponse = null;
            try {
                Object object;
                Object object2;
                ObjectMapper objectMapper = new ObjectMapper();
                HttpPost httpPost = new HttpPost("https://" + this.m_idpHost + OKTA_FACTORS_URL);
                httpPost.addHeader("Accept", "application/json");
                httpPost.addHeader("Content-Type", "application/json");
                httpPost.addHeader("Cache-Control", "no-cache");
                String string2 = jsonNode.get("stateToken").asText();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("stateToken", string2);
                hashMap.put("factorType", this.m_oktaMfaFactorType);
                hashMap.put("provider", this.m_oktaMfaProvider);
                if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.SMSAUTHENTICATION.toString())) {
                    if (StringUtils.isNullOrEmpty(this.m_okta_phone_number)) {
                        throw new IOException("Phone number not specified.");
                    }
                    object2 = new HashMap();
                    object2.put("phoneNumber", this.m_okta_phone_number);
                    hashMap.put("profile", object2);
                }
                object2 = new StringWriter();
                objectMapper.writeValue((Writer)object2, hashMap);
                StringEntity stringEntity = new StringEntity(((StringWriter)object2).toString(), "UTF-8");
                stringEntity.setContentType("application/json");
                httpPost.setEntity(stringEntity);
                if (null != this.m_proxyHost && !this.m_proxyHost.isEmpty() && this.m_useProxyForIdpAuth.booleanValue()) {
                    if (this.m_proxyUid != null && !this.m_proxyUid.isEmpty() && this.m_proxyPwd != null && !this.m_proxyPwd.isEmpty()) {
                        object = new BasicCredentialsProvider();
                        object.setCredentials(new AuthScope(this.m_proxyHost, this.m_proxyPort), new UsernamePasswordCredentials(this.m_proxyUid, this.m_proxyPwd));
                        closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)object).setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).build();
                    }
                    object = new HttpHost(this.m_proxyHost, this.m_proxyPort);
                    RequestConfig requestConfig = RequestConfig.custom().setProxy((HttpHost)object).build();
                    httpPost.setConfig(requestConfig);
                }
                closeableHttpResponse = closeableHttpClient.execute(httpPost);
                object = closeableHttpResponse.getStatusLine();
                int n = object.getStatusCode();
                JsonNode jsonNode2 = objectMapper.readTree(EntityUtils.toString(closeableHttpResponse.getEntity()));
                if (n == 403 || n == 400) {
                    throw new IOException(jsonNode2.get("errorSummary").asText());
                }
                if (n != 200) {
                    throw new IOException(object.getReasonPhrase());
                }
                if (!"MFA_ENROLL_ACTIVATE".equals(jsonNode2.get("status").asText())) break block9;
                LogUtilities.logDebug("Exiting", LogUtils.getLogger());
                string = this.enrollDeviceForOktaMfa(closeableHttpClient, jsonNode2);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(closeableHttpResponse, null);
                throw throwable;
            }
            IOUtils.closeQuietly(closeableHttpResponse, null);
            return string;
        }
        throw new IOException("MFA Enroll Exception.");
    }

    private String enrollDeviceForOktaMfa(CloseableHttpClient closeableHttpClient, JsonNode jsonNode) throws IOException {
        Object object;
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        JsonNode jsonNode2 = jsonNode.path("_embedded").path("factor");
        String string = jsonNode2.path("_embedded").path("activation").path("_links").path("qrcode").path("href").asText();
        if (!this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.SMSAUTHENTICATION.toString())) {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                try {
                    Desktop.getDesktop().browse(new URI(string));
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                }
            } else {
                object = Runtime.getRuntime();
                try {
                    ((Runtime)object).exec("xdg-open " + string);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.OKTAVERIFYWITHPUSH.toString())) {
            int n = 0;
            int n2 = this.m_okta_mfa_wait_time / 10;
            while (n2 > n) {
                try {
                    String string2 = this.pollForFactorEnrollment(closeableHttpClient, jsonNode);
                    if (string2.equals("SUCCESS")) {
                        return string2;
                    }
                    Thread.sleep(10000L);
                    ++n;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            throw new IOException("QR Code Scanning Timeout");
        }
        if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.OKTAVERIFYWITHTOTP.toString()) || this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.GOOGLEAUTHENTICATOR.toString()) || this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.SMSAUTHENTICATION.toString())) {
            object = this.pollForFactorEnrollment(closeableHttpClient, jsonNode);
            if (((String)object).equals("SUCCESS")) {
                LogUtilities.logDebug("Exiting", LogUtils.getLogger());
                return object;
            }
            throw new IOException("Device Activation Failed.");
        }
        throw new IOException("Invalid Factor Type Specified");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String pollForFactorEnrollment(CloseableHttpClient closeableHttpClient, JsonNode jsonNode) throws IOException {
        String string;
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            Object object;
            Object object2;
            Object object3;
            ObjectMapper objectMapper = new ObjectMapper();
            boolean bl = false;
            String string2 = jsonNode.path("_links").path("next").path("href").asText();
            String string3 = string2.substring(8, string2.indexOf("/", 8));
            HttpPost httpPost = new HttpPost(string2);
            httpPost.addHeader("Accept", "application/json");
            httpPost.addHeader("Content-Type", "application/json");
            httpPost.addHeader("Cache-Control", "no-cache");
            String string4 = jsonNode.get("stateToken").asText();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("stateToken", string4);
            if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.OKTAVERIFYWITHPUSH.toString())) {
                hashMap.put("factorType", OKTA_VERIFY_PUSH_FACTOR_TYPE);
                hashMap.put("provider", OKTA_VERIFY_PROVIDER);
            } else if (this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.OKTAVERIFYWITHTOTP.toString()) || this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.GOOGLEAUTHENTICATOR.toString()) || this.m_okta_mfa_type.equalsIgnoreCase(SupportedFactors.SMSAUTHENTICATION.toString())) {
                object3 = JOptionPane.showInputDialog("Please enter passcode to activate your device: ");
                if (null != object3) {
                    hashMap.put("passCode", object3);
                } else {
                    throw new IOException("User cancelled the activation process");
                }
            }
            object3 = new StringWriter();
            objectMapper.writeValue((Writer)object3, hashMap);
            StringEntity stringEntity = new StringEntity(((StringWriter)object3).toString(), "UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity(stringEntity);
            if (!(null == this.m_proxyHost || this.m_proxyHost.isEmpty() || !this.m_useProxyForIdpAuth.booleanValue() || (bl = this.CheckNonProxyHost(string3, this.m_nonProxyHosts)) || this.m_proxyUid == null || this.m_proxyUid.isEmpty() || this.m_proxyPwd == null || this.m_proxyPwd.isEmpty())) {
                object2 = new BasicCredentialsProvider();
                object2.setCredentials(new AuthScope(this.m_proxyHost, this.m_proxyPort), new UsernamePasswordCredentials(this.m_proxyUid, this.m_proxyPwd));
                closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)object2).setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).build();
                HttpHost httpHost = new HttpHost(this.m_proxyHost, this.m_proxyPort);
                object = RequestConfig.custom().setProxy(httpHost).build();
                httpPost.setConfig((RequestConfig)object);
            }
            closeableHttpResponse = closeableHttpClient.execute(httpPost);
            object2 = closeableHttpResponse.getStatusLine();
            int n = object2.getStatusCode();
            object = objectMapper.readTree(EntityUtils.toString(closeableHttpResponse.getEntity()));
            if (n == 403 || n == 401) {
                throw new IOException(((JsonNode)object).get("errorSummary").asText());
            }
            if (n != 200 && n != 202) {
                throw new IOException(object2.getReasonPhrase());
            }
            LogUtilities.logDebug("Exiting", LogUtils.getLogger());
            string = ((JsonNode)object).get("status").asText();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(closeableHttpResponse, null);
            throw throwable;
        }
        IOUtils.closeQuietly(closeableHttpResponse, null);
        return string;
    }

    private String getOktaVerifyState(CloseableHttpClient closeableHttpClient, String string, String string2) throws IOException {
        block7: {
            Object object;
            CloseableHttpResponse closeableHttpResponse;
            block6: {
                String string3;
                LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string), LogUtils.getLogger());
                closeableHttpResponse = null;
                try {
                    int n;
                    Object object2;
                    ObjectMapper objectMapper = new ObjectMapper();
                    boolean bl = false;
                    HttpPost httpPost = new HttpPost(string2);
                    String string4 = string2.substring(8, string2.indexOf("/", 8));
                    httpPost.addHeader("Accept", "application/json");
                    httpPost.addHeader("Content-Type", "application/json");
                    httpPost.addHeader("Cache-Control", "no-cache");
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("stateToken", string);
                    StringWriter stringWriter = new StringWriter();
                    objectMapper.writeValue(stringWriter, hashMap);
                    StringEntity stringEntity = new StringEntity(stringWriter.toString(), "UTF-8");
                    stringEntity.setContentType("application/json");
                    httpPost.setEntity(stringEntity);
                    if (!(null == this.m_proxyHost || this.m_proxyHost.isEmpty() || !this.m_useProxyForIdpAuth.booleanValue() || (bl = this.CheckNonProxyHost(string4, this.m_nonProxyHosts)) || this.m_proxyUid == null || this.m_proxyUid.isEmpty() || this.m_proxyPwd == null || this.m_proxyPwd.isEmpty())) {
                        object2 = new BasicCredentialsProvider();
                        object2.setCredentials(new AuthScope(this.m_proxyHost, this.m_proxyPort), new UsernamePasswordCredentials(this.m_proxyUid, this.m_proxyPwd));
                        closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)object2).setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).build();
                        HttpHost httpHost = new HttpHost(this.m_proxyHost, this.m_proxyPort);
                        object = RequestConfig.custom().setProxy(httpHost).build();
                        httpPost.setConfig((RequestConfig)object);
                    }
                    if ((n = (object2 = (closeableHttpResponse = closeableHttpClient.execute(httpPost)).getStatusLine()).getStatusCode()) != 200) {
                        throw new IOException(object2.getReasonPhrase());
                    }
                    object = objectMapper.readTree(EntityUtils.toString(closeableHttpResponse.getEntity()));
                    if (!"SUCCESS".equals(((JsonNode)object).get("status").asText())) break block6;
                    LogUtilities.logDebug("Exiting", LogUtils.getLogger());
                    string3 = ((JsonNode)object).get("sessionToken").asText();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(closeableHttpResponse, null);
                    throw throwable;
                }
                IOUtils.closeQuietly(closeableHttpResponse, null);
                return string3;
            }
            if (!"MFA_CHALLENGE".equals(((JsonNode)object).get("status").asText())) break block7;
            LogUtilities.logDebug("Exiting", LogUtils.getLogger());
            String string5 = ((JsonNode)object).get("factorResult").asText();
            IOUtils.closeQuietly(closeableHttpResponse, null);
            return string5;
        }
        throw new IOException("Okta Push Verification failed.");
    }

    private String verifyTotpFactor(CloseableHttpClient closeableHttpClient, String string, String string2, String string3) throws IOException {
        block6: {
            String string4;
            LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string3), LogUtils.getLogger());
            CloseableHttpResponse closeableHttpResponse = null;
            try {
                Object object;
                Object object2;
                ObjectMapper objectMapper = new ObjectMapper();
                boolean bl = false;
                HttpPost httpPost = new HttpPost(string2);
                String string5 = string2.substring(8, string2.indexOf("/", 8));
                httpPost.addHeader("Accept", "application/json");
                httpPost.addHeader("Content-Type", "application/json");
                httpPost.addHeader("Cache-Control", "no-cache");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("stateToken", string);
                hashMap.put("passCode", string3);
                StringWriter stringWriter = new StringWriter();
                objectMapper.writeValue(stringWriter, hashMap);
                StringEntity stringEntity = new StringEntity(stringWriter.toString(), "UTF-8");
                stringEntity.setContentType("application/json");
                httpPost.setEntity(stringEntity);
                if (!(null == this.m_proxyHost || this.m_proxyHost.isEmpty() || !this.m_useProxyForIdpAuth.booleanValue() || (bl = this.CheckNonProxyHost(string5, this.m_nonProxyHosts)) || this.m_proxyUid == null || this.m_proxyUid.isEmpty() || this.m_proxyPwd == null || this.m_proxyPwd.isEmpty())) {
                    object2 = new BasicCredentialsProvider();
                    object2.setCredentials(new AuthScope(this.m_proxyHost, this.m_proxyPort), new UsernamePasswordCredentials(this.m_proxyUid, this.m_proxyPwd));
                    closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)object2).setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).build();
                    HttpHost httpHost = new HttpHost(this.m_proxyHost, this.m_proxyPort);
                    object = RequestConfig.custom().setProxy(httpHost).build();
                    httpPost.setConfig((RequestConfig)object);
                }
                closeableHttpResponse = closeableHttpClient.execute(httpPost);
                object2 = closeableHttpResponse.getStatusLine();
                int n = object2.getStatusCode();
                object = objectMapper.readTree(EntityUtils.toString(closeableHttpResponse.getEntity()));
                if (n == 403 || n == 401) {
                    throw new IOException(((JsonNode)object).get("errorSummary").asText());
                }
                if (n != 200) {
                    throw new IOException(object2.getReasonPhrase());
                }
                if (!"SUCCESS".equals(((JsonNode)object).get("status").asText())) break block6;
                LogUtilities.logDebug("Exiting", LogUtils.getLogger());
                string4 = ((JsonNode)object).get("sessionToken").asText();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(closeableHttpResponse, null);
                throw throwable;
            }
            IOUtils.closeQuietly(closeableHttpResponse, null);
            return string4;
        }
        throw new IOException("Okta TOTP Factor failed.");
    }

    static enum SupportedFactors {
        OKTAVERIFYWITHPUSH,
        OKTAVERIFYWITHTOTP,
        SMSAUTHENTICATION,
        GOOGLEAUTHENTICATOR;

    }
}

