/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.dsi.dataengine.utilities;

import com.simba.athena.dsi.core.impl.DSIDriver;
import com.simba.athena.dsi.dataengine.interfaces.IColumn;
import com.simba.athena.dsi.dataengine.utilities.TypeUtilities;
import com.simba.athena.dsi.utilities.DSIMessageKey;
import com.simba.athena.support.exceptions.ErrorException;
import com.simba.athena.support.exceptions.ExceptionType;
import java.util.ArrayList;

public final class TypeMetadata {
    public static final String TN_ARRAY = "SQL_ARRAY";
    public static final String TN_BIGINT = "SQL_BIGINT";
    public static final String TN_BINARY = "SQL_BINARY";
    public static final String TN_BIT = "SQL_BIT";
    public static final String TN_BLOB = "SQL_BLOB";
    public static final String TN_BOOLEAN = "SQL_BOOLEAN";
    public static final String TN_CHAR = "SQL_CHAR";
    public static final String TN_CLOB = "SQL_CLOB";
    public static final String TN_DECIMAL = "SQL_DECIMAL";
    public static final String TN_DOUBLE = "SQL_DOUBLE";
    public static final String TN_FLOAT = "SQL_FLOAT";
    public static final String TN_GUID = "SQL_GUID";
    public static final String TN_INTEGER = "SQL_INTEGER";
    public static final String TN_INTERVAL_DAY = "SQL_INTERVAL_DAY";
    public static final String TN_INTERVAL_DAY_TO_HOUR = "SQL_INTERVAL_DAY_TO_HOUR";
    public static final String TN_INTERVAL_DAY_TO_MINUTE = "SQL_INTERVAL_DAY_TO_MINUTE";
    public static final String TN_INTERVAL_DAY_TO_SECOND = "SQL_INTERVAL_DAY_TO_SECOND";
    public static final String TN_INTERVAL_HOUR = "SQL_INTERVAL_HOUR";
    public static final String TN_INTERVAL_HOUR_TO_MINUTE = "SQL_INTERVAL_HOUR_TO_MINUTE";
    public static final String TN_INTERVAL_HOUR_TO_SECOND = "SQL_INTERVAL_HOUR_TO_SECOND";
    public static final String TN_INTERVAL_MINUTE = "SQL_INTERVAL_MINUTE";
    public static final String TN_INTERVAL_MINUTE_TO_SECOND = "SQL_INTERVAL_MINUTE_TO_SECOND";
    public static final String TN_INTERVAL_MONTH = "SQL_INTERVAL_MONTH";
    public static final String TN_INTERVAL_SECOND = "SQL_INTERVAL_SECOND";
    public static final String TN_INTERVAL_YEAR = "SQL_INTERVAL_YEAR";
    public static final String TN_INTERVAL_YEAR_TO_MONTH = "SQL_INTERVAL_YEAR_TO_MONTH";
    public static final String TN_LONGVARBINARY = "SQL_LONGVARBINARY";
    public static final String TN_LONGVARCHAR = "SQL_LONGVARCHAR";
    public static final String TN_MAP = "MAP";
    public static final String TN_NULL = "NULL";
    public static final String TN_NUMERIC = "SQL_NUMERIC";
    public static final String TN_JAVA_OBJECT = "JAVA_OBJECT";
    public static final String TN_OTHER = "SQL_OTHER";
    public static final String TN_REAL = "SQL_REAL";
    public static final String TN_SMALLINT = "SQL_SMALLINT";
    public static final String TN_STRUCT = "SQL_STRUCT";
    public static final String TN_TINYINT = "SQL_TINYINT";
    public static final String TN_TYPE_DATE = "SQL_TYPE_DATE";
    public static final String TN_TYPE_TIME = "SQL_TYPE_TIME";
    public static final String TN_TYPE_TIMESTAMP = "SQL_TYPE_TIMESTAMP";
    public static final String TN_VARBINARY = "SQL_VARBINARY";
    public static final String TN_VARCHAR = "SQL_VARCHAR";
    public static final String TN_WCHAR = "SQL_WCHAR";
    public static final String TN_WLONGVARCHAR = "SQL_WLONGVARCHAR";
    public static final String TN_WVARCHAR = "SQL_WVARCHAR";
    public static final String TN_SQL92_CHARACTER = "CHARACTER";
    public static final String TN_SQL92_CHAR = "CHAR";
    public static final String TN_SQL92_CHARACTER_VARYING = "CHARACTER VARYING";
    public static final String TN_SQL92_CHAR_VARYING = "CHAR VARYING";
    public static final String TN_SQL92_VARBINARY = "VARBINARY";
    public static final String TN_SQL92_LONGVARBINARY = "LONGVARBINARY";
    public static final String TN_SQL92_VARCHAR = "VARCHAR";
    public static final String TN_SQL92_LONGVARCHAR = "LONGVARCHAR";
    public static final String TN_SQL92_WCHAR = "WCHAR";
    public static final String TN_SQL92_WVARCHAR = "WVARCHAR";
    public static final String TN_SQL92_WLONGVARCHAR = "WLONGVARCHAR";
    public static final String TN_SQL92_BIT = "BIT";
    public static final String TN_SQL92_BIT_VARYING = "BIT VARYING";
    public static final String TN_SQL92_NUMERIC = "NUMERIC";
    public static final String TN_SQL92_DECIMAL = "DECIMAL";
    public static final String TN_SQL92_DEC = "DEC";
    public static final String TN_SQL92_INTEGER = "INTEGER";
    public static final String TN_SQL92_INT = "INT";
    public static final String TN_SQL92_SMALLINT = "SMALLINT";
    public static final String TN_SQL92_BIGINT = "BIGINT";
    public static final String TN_SQL92_TINYINT = "TINYINT";
    public static final String TN_SQL92_DATE = "DATE";
    public static final String TN_SQL92_TIME = "TIME";
    public static final String TN_SQL92_TIMESTAMP = "TIMESTAMP";
    public static final String TN_SQL92_FLOAT = "FLOAT";
    public static final String TN_SQL92_REAL = "REAL";
    public static final String TN_SQL92_DOUBLE = "DOUBLE";
    public static final String TN_SQL92_DOUBLE_PRECISION = "DOUBLE PRECISION";
    public static final String TN_SQL92_INTERVAL_DAY = "INTERVAL DAY";
    public static final String TN_SQL92_INTERVAL_DAY_TO_HOUR = "INTERVAL DAY TO HOUR";
    public static final String TN_SQL92_INTERVAL_DAY_TO_MINUTE = "INTERVAL DAY TO MINUTE";
    public static final String TN_SQL92_INTERVAL_DAY_TO_SECOND = "INTERVAL_DAY TO SECOND";
    public static final String TN_SQL92_INTERVAL_HOUR = "INTERVAL HOUR";
    public static final String TN_SQL92_INTERVAL_HOUR_TO_MINUTE = "INTERVAL HOUR TO MINUTE";
    public static final String TN_SQL92_INTERVAL_HOUR_TO_SECOND = "INTERVAL_HOUR TO SECOND";
    public static final String TN_SQL92_INTERVAL_MINUTE = "INTERVAL MINUTE";
    public static final String TN_SQL92_INTERVAL_MINUTE_TO_SECOND = "INTERVAL MINUTE TO SECOND";
    public static final String TN_SQL92_INTERVAL_MONTH = "INTERVAL MONTH";
    public static final String TN_SQL92_INTERVAL_SECOND = "INTERVAL SECOND";
    public static final String TN_SQL92_INTERVAL_YEAR = "INTERVAL YEAR";
    public static final String TN_SQL92_INTERVAL_YEAR_TO_MONTH = "INTERVAL YEAR TO MONTH";
    private short m_type;
    private String m_localTypeName;
    private String m_typeName;
    private short m_scale;
    private short m_precision;
    private int m_intervalPrecision;
    private boolean m_isSigned;
    private boolean m_isApproximateNumericType;
    private boolean m_isBinaryType;
    private boolean m_isBooleanType;
    private boolean m_isCharacterType;
    private boolean m_isExactNumericType;
    private boolean m_isIntegerType;
    private boolean m_isIntervalType;
    private boolean m_isCurrency = false;
    private boolean m_isSortable = true;
    private ArrayList<IColumn> m_nestedColumnList = null;

    public static TypeMetadata createTypeMetadata(int n) throws ErrorException {
        switch (n) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return TypeMetadata.createTypeMetadata(n, true);
            }
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 1111: 
            case 2000: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: {
                return TypeMetadata.createTypeMetadata(n, false);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED_NUM.name(), String.valueOf(n), ExceptionType.DATA);
    }

    public static TypeMetadata createTypeMetadata(int n, boolean bl) throws ErrorException {
        switch (n) {
            case 2003: {
                ArrayList<IColumn> arrayList = new ArrayList<IColumn>();
                TypeMetadata typeMetadata = new TypeMetadata((short)n, TN_ARRAY.substring(4), 0, 0, 0, bl, arrayList);
                typeMetadata.setIsSortable(false);
                return typeMetadata;
            }
            case -5: {
                return TypeMetadata.createTypeMetadata(n, (short)19, (short)0, 19, bl);
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return TypeMetadata.createTypeMetadata(n, (short)1, (short)0, 1, bl);
            }
            case -7: 
            case 16: {
                return TypeMetadata.createTypeMetadata(n, (short)1, (short)0, 0, bl);
            }
            case 2: 
            case 3: {
                return TypeMetadata.createTypeMetadata(n, (short)38, (short)0, 38, bl);
            }
            case 6: 
            case 8: {
                return TypeMetadata.createTypeMetadata(n, (short)15, (short)0, 53, bl);
            }
            case -11: {
                return TypeMetadata.createTypeMetadata(n, (short)36, (short)0, 36, bl);
            }
            case 4: {
                return TypeMetadata.createTypeMetadata(n, (short)10, (short)0, 0, bl);
            }
            case 0: {
                return TypeMetadata.createTypeMetadata(n, (short)0, (short)0, 0, bl);
            }
            case 7: {
                return TypeMetadata.createTypeMetadata(n, (short)7, (short)0, 24, bl);
            }
            case 5: {
                return TypeMetadata.createTypeMetadata(n, (short)5, (short)0, 5, bl);
            }
            case -6: {
                return TypeMetadata.createTypeMetadata(n, (short)3, (short)0, 3, bl);
            }
            case 91: {
                return TypeMetadata.createTypeMetadata(n, (short)0, (short)0, 10, bl);
            }
            case 92: {
                return TypeMetadata.createTypeMetadata(n, (short)0, (short)0, 8, bl);
            }
            case 93: {
                return TypeMetadata.createTypeMetadata(n, (short)6, (short)6, 0, bl);
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 111: {
                return TypeMetadata.createTypeMetadata(n, (short)0, (short)0, 2, bl);
            }
            case 106: 
            case 110: 
            case 112: 
            case 113: {
                return TypeMetadata.createTypeMetadata(n, (short)6, (short)6, 2, bl);
            }
            case -10: 
            case -9: 
            case -8: {
                return TypeMetadata.createTypeMetadata(n, (short)0, (short)0, 0, bl);
            }
            case 2002: {
                ArrayList<IColumn> arrayList = new ArrayList<IColumn>();
                TypeMetadata typeMetadata = new TypeMetadata((short)n, TN_STRUCT.substring(4), 0, 0, 0, bl, arrayList);
                typeMetadata.setIsSortable(false);
                return typeMetadata;
            }
            case 1111: 
            case 2000: 
            case 2004: 
            case 2005: {
                return TypeMetadata.createTypeMetadata(n, (short)0, (short)0, 0, bl);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED_NUM.name(), String.valueOf(n), ExceptionType.DATA);
    }

    public static TypeMetadata createTypeMetadata(int n, short s, short s2, int n2, boolean bl) throws ErrorException {
        String string = TypeUtilities.sqlTypeToString((short)n);
        if (null == string) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED_NUM.name(), String.valueOf(n), ExceptionType.DATA);
        }
        if (string.startsWith("SQL_")) {
            string = string.substring(4);
        }
        return new TypeMetadata((short)n, string, s, s2, n2, bl);
    }

    public TypeMetadata(short s, String string, short s2, short s3, int n) {
        this(s, string, s2, s3, n, false, null);
    }

    public TypeMetadata(short s, String string, short s2, short s3, int n, boolean bl) {
        this(s, string, s2, s3, n, bl, null);
    }

    public TypeMetadata(short s, String string, short s2, short s3, int n, boolean bl, ArrayList<IColumn> arrayList) {
        this.m_type = s;
        this.m_typeName = string;
        this.m_localTypeName = string;
        this.m_precision = s2;
        this.m_scale = s3;
        this.m_intervalPrecision = n;
        this.m_isSigned = bl;
        this.m_nestedColumnList = arrayList;
        this.m_isApproximateNumericType = TypeUtilities.isApproximateNumericType(this.m_type);
        this.m_isBinaryType = TypeUtilities.isBinaryType(this.m_type);
        this.m_isCharacterType = TypeUtilities.isCharacterType(this.m_type);
        this.m_isExactNumericType = TypeUtilities.isExactNumericType(this.m_type);
        this.m_isIntegerType = TypeUtilities.isIntegerType(this.m_type);
        this.m_isIntervalType = TypeUtilities.isIntervalType(this.m_type);
        this.m_isBooleanType = TypeUtilities.isBooleanType(this.m_type);
    }

    public void assign(TypeMetadata typeMetadata) {
        this.m_type = typeMetadata.m_type;
        this.m_localTypeName = typeMetadata.m_localTypeName;
        this.m_typeName = typeMetadata.m_typeName;
        this.m_scale = typeMetadata.m_scale;
        this.m_precision = typeMetadata.m_precision;
        this.m_intervalPrecision = typeMetadata.m_intervalPrecision;
        this.m_isSigned = typeMetadata.m_isSigned;
        this.m_isApproximateNumericType = typeMetadata.m_isApproximateNumericType;
        this.m_isBinaryType = typeMetadata.m_isBinaryType;
        this.m_isBooleanType = typeMetadata.m_isBooleanType;
        this.m_isCharacterType = typeMetadata.m_isCharacterType;
        this.m_isExactNumericType = typeMetadata.m_isExactNumericType;
        this.m_isIntegerType = typeMetadata.m_isIntegerType;
        this.m_isIntervalType = typeMetadata.m_isIntervalType;
        this.m_isCurrency = typeMetadata.m_isCurrency;
        this.m_isSortable = typeMetadata.m_isSortable;
        this.m_nestedColumnList = typeMetadata.m_nestedColumnList == null ? null : new ArrayList<IColumn>(typeMetadata.m_nestedColumnList);
    }

    public static TypeMetadata copyOf(TypeMetadata typeMetadata) {
        TypeMetadata typeMetadata2 = new TypeMetadata(typeMetadata.getType(), typeMetadata.getTypeName(), typeMetadata.getPrecision(), typeMetadata.getScale(), typeMetadata.getIntervalPrecision(), typeMetadata.isSigned());
        ArrayList<IColumn> arrayList = null;
        if (null != typeMetadata.getNestedColumnList()) {
            arrayList = new ArrayList<IColumn>(typeMetadata.getNestedColumnList());
        }
        typeMetadata2.setNestedColumnList(arrayList);
        typeMetadata2.setIsCurrency(typeMetadata.isCurrency());
        typeMetadata2.setIsSortable(typeMetadata.isSortable());
        return typeMetadata2;
    }

    public int getIntervalPrecision() {
        return this.m_intervalPrecision;
    }

    public String getLocalTypeName() {
        return this.m_localTypeName;
    }

    public short getPrecision() {
        return this.m_precision;
    }

    public short getScale() {
        return this.m_scale;
    }

    public short getType() {
        return this.m_type;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public boolean isApproximateNumericType() {
        return this.m_isApproximateNumericType;
    }

    public boolean isBooleanType() {
        return this.m_isBooleanType;
    }

    public boolean isBinaryType() {
        return this.m_isBinaryType;
    }

    public boolean isCharacterOrBinaryType() {
        return this.m_isCharacterType || this.m_isBinaryType;
    }

    public boolean isCharacterType() {
        return this.m_isCharacterType;
    }

    public boolean isCurrency() {
        return this.m_isCurrency;
    }

    public boolean isExactNumericType() {
        return this.m_isExactNumericType;
    }

    public boolean isIntegerType() {
        return this.m_isIntegerType;
    }

    public boolean isIntervalType() {
        return this.m_isIntervalType;
    }

    public boolean isSigned() {
        return this.m_isSigned;
    }

    public boolean isSortable() {
        return this.m_isSortable;
    }

    public void setIntervalPrecision(int n) {
        this.m_intervalPrecision = n;
    }

    public void setIsCurrency(boolean bl) {
        this.m_isCurrency = bl;
    }

    public void setIsSortable(boolean bl) {
        this.m_isSortable = bl;
    }

    public void setLocalTypeName(String string) {
        this.m_localTypeName = string;
    }

    public void setPrecision(short s) {
        this.m_precision = s;
    }

    public void setScale(short s) {
        this.m_scale = s;
    }

    public void setSigned(boolean bl) {
        this.m_isSigned = bl;
    }

    public void setTypeName(String string) {
        this.m_typeName = string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.m_intervalPrecision;
        n = 31 * n + (this.m_isApproximateNumericType ? 1231 : 1237);
        n = 31 * n + (this.m_isBinaryType ? 1231 : 1237);
        n = 31 * n + (this.m_isBooleanType ? 1231 : 1237);
        n = 31 * n + (this.m_isCharacterType ? 1231 : 1237);
        n = 31 * n + (this.m_isExactNumericType ? 1231 : 1237);
        n = 31 * n + (this.m_isIntegerType ? 1231 : 1237);
        n = 31 * n + (this.m_isIntervalType ? 1231 : 1237);
        n = 31 * n + (this.m_isSigned ? 1231 : 1237);
        n = 31 * n + this.m_precision;
        n = 31 * n + this.m_scale;
        n = 31 * n + this.m_type;
        n = 31 * n + (this.m_typeName == null ? 0 : this.m_typeName.hashCode());
        n = 31 * n + (this.m_nestedColumnList == null ? 0 : this.m_nestedColumnList.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TypeMetadata typeMetadata = (TypeMetadata)object;
        if (this.m_intervalPrecision != typeMetadata.m_intervalPrecision) {
            return false;
        }
        if (this.m_isApproximateNumericType != typeMetadata.m_isApproximateNumericType) {
            return false;
        }
        if (this.m_isBinaryType != typeMetadata.m_isBinaryType) {
            return false;
        }
        if (this.m_isBooleanType != typeMetadata.m_isBooleanType) {
            return false;
        }
        if (this.m_isCharacterType != typeMetadata.m_isCharacterType) {
            return false;
        }
        if (this.m_isExactNumericType != typeMetadata.m_isExactNumericType) {
            return false;
        }
        if (this.m_isIntegerType != typeMetadata.m_isIntegerType) {
            return false;
        }
        if (this.m_isIntervalType != typeMetadata.m_isIntervalType) {
            return false;
        }
        if (this.m_isSigned != typeMetadata.m_isSigned) {
            return false;
        }
        if (this.m_precision != typeMetadata.m_precision) {
            return false;
        }
        if (this.m_scale != typeMetadata.m_scale) {
            return false;
        }
        if (this.m_type != typeMetadata.m_type) {
            return false;
        }
        if (this.m_typeName == null ? typeMetadata.m_typeName != null : !this.m_typeName.equals(typeMetadata.m_typeName)) {
            return false;
        }
        if (this.m_nestedColumnList == null && typeMetadata.m_nestedColumnList != null) {
            return false;
        }
        return this.m_nestedColumnList == null || this.m_nestedColumnList.equals(typeMetadata.m_nestedColumnList);
    }

    public ArrayList<IColumn> getNestedColumnList() {
        return this.m_nestedColumnList;
    }

    public void setNestedColumnList(ArrayList<IColumn> arrayList) {
        this.m_nestedColumnList = arrayList;
    }
}

