/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.dsi.core.utilities.impl.future;

import com.simba.athena.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.simba.athena.dsi.core.utilities.impl.future.ConversionConfig;
import com.simba.athena.dsi.core.utilities.impl.future.NumberJDBCDataSink;
import com.simba.athena.dsi.exceptions.ConversionFailed;
import com.simba.athena.dsi.exceptions.IncorrectTypeException;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class UnsignedIntJDBCDataSink
extends NumberJDBCDataSink<Long> {
    protected static final long TWO_TO_32 = 0x100000000L;

    public UnsignedIntJDBCDataSink(IWarningListener iWarningListener, ConversionConfig conversionConfig) {
        super(iWarningListener, conversionConfig);
    }

    @Override
    protected abstract void doSet(Long var1) throws ErrorException;

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException, ConversionFailed {
        if (object == null) {
            this.doSet((Long)null);
        } else {
            BigDecimal bigDecimal = NonTrivialJDBCConversions.objectToBigDecimal(object, null, this.getAndClearListener());
            long l = NonTrivialJDBCConversions.DecimalConverter.toUInt32(bigDecimal, this.getAndClearListener());
            this.handleConversionResult(object, "set");
            this.doSet(l);
        }
    }

    @Override
    public void setByte(byte by) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        long l = NonTrivialJDBCConversions.LongConverter.toUInt32(by, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(by, "setByte");
        }
        this.doSet(l);
    }

    @Override
    public void setShort(short s) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        long l = NonTrivialJDBCConversions.LongConverter.toUInt32(s, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(s, "setShort");
        }
        this.doSet(l);
    }

    @Override
    public void setInt(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        long l = NonTrivialJDBCConversions.LongConverter.toUInt32(n, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(n, "setInt");
        }
        this.doSet(l);
    }

    @Override
    public void setLong(long l) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        long l2 = NonTrivialJDBCConversions.LongConverter.toUInt32(l, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(l, "setLong");
        }
        this.doSet(l2);
    }

    @Override
    public void setFloat(float f) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        long l = NonTrivialJDBCConversions.DoubleConverter.toUInt32(f, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(Float.valueOf(f), "setFloat");
        }
        this.doSet(l);
    }

    @Override
    public void setDouble(double d) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        long l = NonTrivialJDBCConversions.DoubleConverter.toUInt32(d, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(d, "setDouble");
        }
        this.doSet(l);
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (bigDecimal == null) {
            this.setNull(3);
        } else {
            long l = NonTrivialJDBCConversions.DecimalConverter.toUInt32(bigDecimal, this.getAndClearListener());
            if (!this.conversionSuccessful()) {
                this.handleConversionResult(bigDecimal, "setBigDecimal");
            }
            this.doSet(l);
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            string = string.trim();
            try {
                this.setLong(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                long l = NonTrivialJDBCConversions.DecimalConverter.toUInt32(NonTrivialJDBCConversions.stringToBigDecimal(string), this.getAndClearListener());
                if (!this.conversionSuccessful()) {
                    this.handleConversionResult(string, "setString");
                }
                this.doSet(l);
            }
        }
    }
}

