/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.dsi.core.utilities.impl.future;

import com.simba.athena.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.simba.athena.dsi.core.utilities.impl.future.ConversionConfig;
import com.simba.athena.dsi.core.utilities.impl.future.ConvertingJDBCDataSource;
import com.simba.athena.dsi.dataengine.interfaces.future.IJDBCExecution;
import com.simba.athena.dsi.dataengine.utilities.DSIMonthSpan;
import com.simba.athena.dsi.dataengine.utilities.TypeMetadata;
import com.simba.athena.dsi.exceptions.ConversionFailed;
import com.simba.athena.dsi.exceptions.IncorrectTypeException;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.exceptions.ErrorException;
import java.sql.SQLException;

public abstract class MonthSpanJDBCDataSource
extends ConvertingJDBCDataSource {
    private final int m_sqlType;
    private final int m_leadingFieldPrecision;

    public MonthSpanJDBCDataSource(IWarningListener iWarningListener, TypeMetadata typeMetadata, ConversionConfig conversionConfig) {
        super(iWarningListener, conversionConfig);
        this.m_sqlType = typeMetadata.getType();
        switch (this.m_sqlType) {
            case 101: 
            case 102: 
            case 107: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected SQL type " + this.m_sqlType);
            }
        }
        this.m_leadingFieldPrecision = typeMetadata.getIntervalPrecision();
        assert (this.m_leadingFieldPrecision > 0 && this.m_leadingFieldPrecision <= 9);
    }

    protected final int getSqlType() {
        return this.m_sqlType;
    }

    protected final int getLeadingFieldPrecision() {
        return this.m_leadingFieldPrecision;
    }

    @Override
    public abstract DSIMonthSpan get() throws ErrorException;

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        DSIMonthSpan dSIMonthSpan = this.get();
        if (dSIMonthSpan == null) {
            return null;
        }
        return NonTrivialJDBCConversions.monthSpanToString(dSIMonthSpan, this.m_sqlType, this.getIntervalConverter(), this.m_leadingFieldPrecision);
    }

    @Override
    protected boolean supportsConversionToRegisteredType(IJDBCExecution.OutputParameterRegistration outputParameterRegistration) {
        int n = this.getSqlTypeFromRegistration(outputParameterRegistration);
        switch (n) {
            case 101: 
            case 102: 
            case 107: 
            case 2000: {
                return true;
            }
        }
        return this.isCharType(n);
    }
}

