/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.dsi.core.utilities.impl.future;

import com.simba.athena.dsi.core.utilities.impl.future.ConversionConfig;
import com.simba.athena.dsi.core.utilities.impl.future.ConvertingJDBCDataSink;
import com.simba.athena.dsi.exceptions.ConversionFailed;
import com.simba.athena.dsi.exceptions.IncorrectTypeException;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.exceptions.ErrorException;
import java.io.InputStream;
import java.sql.SQLException;

public abstract class BinaryJDBCDataSink
extends ConvertingJDBCDataSink {
    public BinaryJDBCDataSink(IWarningListener iWarningListener, ConversionConfig conversionConfig) {
        super(iWarningListener, conversionConfig);
    }

    protected abstract void doSet(byte[] var1) throws ErrorException;

    protected abstract void doSet(InputStream var1) throws ErrorException;

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object == null) {
            this.doSet((byte[])null);
        } else if (object instanceof byte[]) {
            this.doSet((byte[])object);
        } else if (object instanceof InputStream) {
            this.doSet((InputStream)object);
        } else {
            throw new IncorrectTypeException();
        }
    }

    @Override
    public void setNull(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        switch (n) {
            case -4: 
            case -3: 
            case -2: 
            case 0: {
                this.doSet((byte[])null);
                break;
            }
            default: {
                throw new IncorrectTypeException();
            }
        }
    }

    @Override
    public void setBytes(byte[] byArray) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.doSet(byArray);
    }

    @Override
    public void setBinaryStream(InputStream inputStream) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.doSet(inputStream);
    }
}

