/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine.metadata;

import com.simba.athena.amazonaws.services.athena.model.DataCatalogSummary;
import com.simba.athena.athena.AJMetadataRetrievalMethod;
import com.simba.athena.athena.api.AJClient;
import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.athena.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.athena.dsi.dataengine.utilities.DataWrapper;
import com.simba.athena.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class AJCatalogOnlyMetadataSource
implements IMetadataSource {
    private AJClient m_client;
    private ILogger m_logger;
    private List<DataCatalogSummary> m_catalogList = new ArrayList<DataCatalogSummary>();
    private ListIterator<DataCatalogSummary> m_catalogIterator;
    private DataCatalogSummary m_currentCatalog;

    public AJCatalogOnlyMetadataSource(ILogger iLogger, AJClient aJClient) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_logger = iLogger;
        this.m_client = aJClient;
        if (AJMetadataRetrievalMethod.GET_METADATA_FROM_PROXY_API == this.m_client.getMetadataRetrievalMethod()) {
            this.m_catalogList = this.m_client.getCatalogsWtihProxyApi();
        } else {
            DataCatalogSummary dataCatalogSummary = new DataCatalogSummary();
            dataCatalogSummary.setCatalogName("AwsDataCatalog");
            this.m_catalogList.add(dataCatalogSummary);
        }
        this.m_catalogIterator = this.m_catalogList.listIterator(0);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentCatalog.getCatalogName(), dataWrapper, l, l2);
            }
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_catalogIterator.hasNext();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.hasMoreRows()) {
            this.m_currentCatalog = this.m_catalogIterator.next();
            return true;
        }
        return false;
    }
}

