/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.services.glue.model.CatalogSource;
import com.simba.athena.amazonaws.transform.JsonUnmarshallerContext;
import com.simba.athena.amazonaws.transform.Unmarshaller;
import com.simba.athena.shaded.fasterxml.jackson.core.JsonToken;

public class CatalogSourceJsonUnmarshaller
implements Unmarshaller<CatalogSource, JsonUnmarshallerContext> {
    private static CatalogSourceJsonUnmarshaller instance;

    @Override
    public CatalogSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        CatalogSource catalogSource = new CatalogSource();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    catalogSource.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Database", targetDepth)) {
                    context.nextToken();
                    catalogSource.setDatabase(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Table", targetDepth)) {
                    context.nextToken();
                    catalogSource.setTable(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return catalogSource;
    }

    public static CatalogSourceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CatalogSourceJsonUnmarshaller();
        }
        return instance;
    }
}

