/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model;

import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.protocol.StructuredPojo;
import com.simba.athena.amazonaws.services.glue.model.UnionType;
import com.simba.athena.amazonaws.services.glue.model.transform.UnionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Union
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<String> inputs;
    private String unionType;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Union withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(Collection<String> inputs) {
        if (inputs == null) {
            this.inputs = null;
            return;
        }
        this.inputs = new ArrayList<String>(inputs);
    }

    public Union withInputs(String ... inputs) {
        if (this.inputs == null) {
            this.setInputs(new ArrayList<String>(inputs.length));
        }
        for (String ele : inputs) {
            this.inputs.add(ele);
        }
        return this;
    }

    public Union withInputs(Collection<String> inputs) {
        this.setInputs(inputs);
        return this;
    }

    public void setUnionType(String unionType) {
        this.unionType = unionType;
    }

    public String getUnionType() {
        return this.unionType;
    }

    public Union withUnionType(String unionType) {
        this.setUnionType(unionType);
        return this;
    }

    public Union withUnionType(UnionType unionType) {
        this.unionType = unionType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getInputs() != null) {
            sb.append("Inputs: ").append(this.getInputs()).append(",");
        }
        if (this.getUnionType() != null) {
            sb.append("UnionType: ").append(this.getUnionType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Union)) {
            return false;
        }
        Union other = (Union)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getInputs() == null ^ this.getInputs() == null) {
            return false;
        }
        if (other.getInputs() != null && !other.getInputs().equals(this.getInputs())) {
            return false;
        }
        if (other.getUnionType() == null ^ this.getUnionType() == null) {
            return false;
        }
        return other.getUnionType() == null || other.getUnionType().equals(this.getUnionType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getInputs() == null ? 0 : this.getInputs().hashCode());
        hashCode = 31 * hashCode + (this.getUnionType() == null ? 0 : this.getUnionType().hashCode());
        return hashCode;
    }

    public Union clone() {
        try {
            return (Union)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UnionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

