/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model;

import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.protocol.StructuredPojo;
import com.simba.athena.amazonaws.services.glue.model.FilterExpression;
import com.simba.athena.amazonaws.services.glue.model.FilterLogicalOperator;
import com.simba.athena.amazonaws.services.glue.model.transform.FilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Filter
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<String> inputs;
    private String logicalOperator;
    private List<FilterExpression> filters;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Filter withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(Collection<String> inputs) {
        if (inputs == null) {
            this.inputs = null;
            return;
        }
        this.inputs = new ArrayList<String>(inputs);
    }

    public Filter withInputs(String ... inputs) {
        if (this.inputs == null) {
            this.setInputs(new ArrayList<String>(inputs.length));
        }
        for (String ele : inputs) {
            this.inputs.add(ele);
        }
        return this;
    }

    public Filter withInputs(Collection<String> inputs) {
        this.setInputs(inputs);
        return this;
    }

    public void setLogicalOperator(String logicalOperator) {
        this.logicalOperator = logicalOperator;
    }

    public String getLogicalOperator() {
        return this.logicalOperator;
    }

    public Filter withLogicalOperator(String logicalOperator) {
        this.setLogicalOperator(logicalOperator);
        return this;
    }

    public Filter withLogicalOperator(FilterLogicalOperator logicalOperator) {
        this.logicalOperator = logicalOperator.toString();
        return this;
    }

    public List<FilterExpression> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<FilterExpression> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<FilterExpression>(filters);
    }

    public Filter withFilters(FilterExpression ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<FilterExpression>(filters.length));
        }
        for (FilterExpression ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public Filter withFilters(Collection<FilterExpression> filters) {
        this.setFilters(filters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getInputs() != null) {
            sb.append("Inputs: ").append(this.getInputs()).append(",");
        }
        if (this.getLogicalOperator() != null) {
            sb.append("LogicalOperator: ").append(this.getLogicalOperator()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getInputs() == null ^ this.getInputs() == null) {
            return false;
        }
        if (other.getInputs() != null && !other.getInputs().equals(this.getInputs())) {
            return false;
        }
        if (other.getLogicalOperator() == null ^ this.getLogicalOperator() == null) {
            return false;
        }
        if (other.getLogicalOperator() != null && !other.getLogicalOperator().equals(this.getLogicalOperator())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || other.getFilters().equals(this.getFilters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getInputs() == null ? 0 : this.getInputs().hashCode());
        hashCode = 31 * hashCode + (this.getLogicalOperator() == null ? 0 : this.getLogicalOperator().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        return hashCode;
    }

    public Filter clone() {
        try {
            return (Filter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

