/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model;

import com.simba.athena.amazonaws.AmazonWebServiceResult;
import com.simba.athena.amazonaws.ResponseMetadata;
import com.simba.athena.amazonaws.services.glue.model.Blueprint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetBlueprintsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Blueprint> blueprints;
    private List<String> missingBlueprints;

    public List<Blueprint> getBlueprints() {
        return this.blueprints;
    }

    public void setBlueprints(Collection<Blueprint> blueprints) {
        if (blueprints == null) {
            this.blueprints = null;
            return;
        }
        this.blueprints = new ArrayList<Blueprint>(blueprints);
    }

    public BatchGetBlueprintsResult withBlueprints(Blueprint ... blueprints) {
        if (this.blueprints == null) {
            this.setBlueprints(new ArrayList<Blueprint>(blueprints.length));
        }
        for (Blueprint ele : blueprints) {
            this.blueprints.add(ele);
        }
        return this;
    }

    public BatchGetBlueprintsResult withBlueprints(Collection<Blueprint> blueprints) {
        this.setBlueprints(blueprints);
        return this;
    }

    public List<String> getMissingBlueprints() {
        return this.missingBlueprints;
    }

    public void setMissingBlueprints(Collection<String> missingBlueprints) {
        if (missingBlueprints == null) {
            this.missingBlueprints = null;
            return;
        }
        this.missingBlueprints = new ArrayList<String>(missingBlueprints);
    }

    public BatchGetBlueprintsResult withMissingBlueprints(String ... missingBlueprints) {
        if (this.missingBlueprints == null) {
            this.setMissingBlueprints(new ArrayList<String>(missingBlueprints.length));
        }
        for (String ele : missingBlueprints) {
            this.missingBlueprints.add(ele);
        }
        return this;
    }

    public BatchGetBlueprintsResult withMissingBlueprints(Collection<String> missingBlueprints) {
        this.setMissingBlueprints(missingBlueprints);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBlueprints() != null) {
            sb.append("Blueprints: ").append(this.getBlueprints()).append(",");
        }
        if (this.getMissingBlueprints() != null) {
            sb.append("MissingBlueprints: ").append(this.getMissingBlueprints());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetBlueprintsResult)) {
            return false;
        }
        BatchGetBlueprintsResult other = (BatchGetBlueprintsResult)obj;
        if (other.getBlueprints() == null ^ this.getBlueprints() == null) {
            return false;
        }
        if (other.getBlueprints() != null && !other.getBlueprints().equals(this.getBlueprints())) {
            return false;
        }
        if (other.getMissingBlueprints() == null ^ this.getMissingBlueprints() == null) {
            return false;
        }
        return other.getMissingBlueprints() == null || other.getMissingBlueprints().equals(this.getMissingBlueprints());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBlueprints() == null ? 0 : this.getBlueprints().hashCode());
        hashCode = 31 * hashCode + (this.getMissingBlueprints() == null ? 0 : this.getMissingBlueprints().hashCode());
        return hashCode;
    }

    public BatchGetBlueprintsResult clone() {
        try {
            return (BatchGetBlueprintsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

