/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.io;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.logging.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class CertChecker {
    public static void checkCert(TDNetworkIOIF tDNetworkIOIF, TDNetworkIOIF.ConnectThread connectThread) throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Object object;
        X509Certificate[] x509CertificateArray;
        Certificate[] certificateArray;
        X509TrustManager x509TrustManager;
        X509TrustManager x509TrustManager2;
        X509TrustManager x509TrustManager3;
        X509TrustManager x509TrustManager4;
        String string;
        String string2;
        String string3;
        block27: {
            SSLSession sSLSession = ((SSLSocket)connectThread.m_socket).getSession();
            if (tDNetworkIOIF.log.isDebugEnabled()) {
                tDNetworkIOIF.log.debug("SSLSession.getProtocol=" + sSLSession.getProtocol() + " getCipherSuite=" + sSLSession.getCipherSuite());
            }
            string3 = tDNetworkIOIF.m_con.getURLParameters().getSSLCA();
            string2 = tDNetworkIOIF.m_con.getURLParameters().getSSLCAPath();
            string = tDNetworkIOIF.m_con.getURLParameters().getSSLTrustStore();
            if (tDNetworkIOIF.log.isDebugEnabled()) {
                tDNetworkIOIF.log.debug(">>>>> createTrustManagerFromPEMFile(" + string3 + ")");
            }
            x509TrustManager4 = CertChecker.createTrustManagerFromPEMFile(string3, tDNetworkIOIF.log, "SSLCA=" + string3);
            if (tDNetworkIOIF.log.isDebugEnabled()) {
                tDNetworkIOIF.log.debug("<<<<< createTrustManagerFromPEMFile(" + string3 + ") returned " + x509TrustManager4);
            }
            if (tDNetworkIOIF.log.isDebugEnabled()) {
                tDNetworkIOIF.log.debug(">>>>> createTrustManagerFromPEMDirectory(" + string2 + ")");
            }
            x509TrustManager3 = CertChecker.createTrustManagerFromPEMDirectory(string2, tDNetworkIOIF.log, "SSLCAPATH=" + string2);
            if (tDNetworkIOIF.log.isDebugEnabled()) {
                tDNetworkIOIF.log.debug("<<<<< createTrustManagerFromPEMDirectory(" + string2 + ") returned " + x509TrustManager3);
            }
            if (tDNetworkIOIF.log.isDebugEnabled()) {
                tDNetworkIOIF.log.debug(">>>>> createTrustManagerFromTrustStoreFile(" + string + ")");
            }
            x509TrustManager2 = CertChecker.createTrustManagerFromTrustStoreFile(string, tDNetworkIOIF.log);
            if (tDNetworkIOIF.log.isDebugEnabled()) {
                tDNetworkIOIF.log.debug("<<<<< createTrustManagerFromTrustStoreFile(" + string + ") returned " + x509TrustManager2);
            }
            if (tDNetworkIOIF.log.isDebugEnabled()) {
                tDNetworkIOIF.log.debug(">>>>> getDefaultTrustManager");
            }
            x509TrustManager = CertChecker.getDefaultTrustManager(tDNetworkIOIF.log);
            if (tDNetworkIOIF.log.isDebugEnabled()) {
                tDNetworkIOIF.log.debug("<<<<< getDefaultTrustManager returned " + x509TrustManager);
            }
            certificateArray = null;
            try {
                certificateArray = sSLSession.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                if (!tDNetworkIOIF.log.isInfoEnabled()) break block27;
                tDNetworkIOIF.log.info("getPeerCertificates failed for connection to " + connectThread.m_isa, sSLPeerUnverifiedException);
            }
        }
        X509Certificate[] x509CertificateArray2 = x509CertificateArray = certificateArray instanceof X509Certificate[] ? (X509Certificate[])certificateArray : null;
        if (tDNetworkIOIF.log.isInfoEnabled()) {
            for (int i = 0; certificateArray != null && i < certificateArray.length; ++i) {
                object = x509CertificateArray != null ? x509CertificateArray[i] : null;
                tDNetworkIOIF.log.info("getPeerCertificates returned certificate " + (i + 1) + " of " + certificateArray.length + (i == 0 ? " which is the peer certificate" : "") + "\n  Certificate " + (object != null ? "is" : "is not") + " an X509Certificate" + "\n  Certificate date range is " + CertChecker.formatDateRange((X509Certificate)object) + "\n  Certificate " + CertChecker.formatValidity((X509Certificate)object) + "\n  Certificate purpose is " + CertChecker.formatCertPurpose((X509Certificate)object) + "\n  Subject Distinguished Name (DN) is " + CertChecker.formatDN((X509Certificate)object) + "\n  Subject Common Name (CN) is " + CertChecker.formatCN((X509Certificate)object) + "\n  Subject Alternative Names (SANs) are " + CertChecker.formatSANs((X509Certificate)object) + "\n" + CertChecker.formatCert(certificateArray[i]));
            }
        }
        List list = CertChecker.getValidityProblems(x509CertificateArray);
        object = CertChecker.getServerCertProblems(x509TrustManager4, x509CertificateArray, "SSLCA=" + string3);
        List list2 = CertChecker.getServerCertProblems(x509TrustManager3, x509CertificateArray, "SSLCAPATH=" + string2);
        List list3 = CertChecker.getServerCertProblems(x509TrustManager2, x509CertificateArray, "SSLTRUSTSTORE=" + string);
        List list4 = CertChecker.getServerCertProblems(x509TrustManager, x509CertificateArray, "Default Java");
        if (tDNetworkIOIF.log.isInfoEnabled()) {
            tDNetworkIOIF.log.info("getValidityProblems " + (list.isEmpty() ? "accepted certificate" : "found " + list.size() + " certificate problem(s): " + CertChecker.formatList(list, ", ", null)));
            tDNetworkIOIF.log.info("createTrustManagerFromPEMFile(" + string3 + ") " + (x509TrustManager4 == null ? "is not available" : (object.isEmpty() ? "accepted certificate" : "found " + object.size() + " certificate problem(s): " + CertChecker.formatList((List)object, ", ", null))));
            tDNetworkIOIF.log.info("createTrustManagerFromPEMDirectory(" + string2 + ") " + (x509TrustManager3 == null ? "is not available" : (list2.isEmpty() ? "accepted certificate" : "found " + list2.size() + " certificate problem(s): " + CertChecker.formatList(list2, ", ", null))));
            tDNetworkIOIF.log.info("createTrustManagerFromTrustStoreFile(" + string + ") " + (x509TrustManager2 == null ? "is not available" : (list3.isEmpty() ? "accepted certificate" : "found " + list3.size() + " certificate problem(s): " + CertChecker.formatList(list3, ", ", null))));
            tDNetworkIOIF.log.info("getDefaultTrustManager " + (x509TrustManager == null ? "is not available" : (list4.isEmpty() ? "accepted certificate" : "found " + list4.size() + " certificate problem(s): " + CertChecker.formatList(list4, ", ", null))));
        }
        boolean bl4 = x509TrustManager4 != null || x509TrustManager3 != null || x509TrustManager2 != null || x509TrustManager != null;
        boolean bl5 = x509TrustManager4 != null && object.isEmpty();
        boolean bl6 = x509TrustManager3 != null && list2.isEmpty();
        boolean bl7 = x509TrustManager2 != null && list3.isEmpty();
        boolean bl8 = x509TrustManager != null && list4.isEmpty();
        boolean bl9 = bl5 || bl6 || bl7 || bl8;
        boolean bl10 = bl3 = list.isEmpty() && bl4 && bl9;
        if (tDNetworkIOIF.log.isInfoEnabled()) {
            tDNetworkIOIF.log.info("SSLMODE=VERIFY-CA would " + (bl3 ? "accept" : "reject") + " this connection");
        }
        X509Certificate x509Certificate = x509CertificateArray != null ? x509CertificateArray[0] : null;
        String[] stringArray = connectThread.m_isa.getAddress().toString().split("/");
        boolean bl11 = stringArray[0].length() == 0;
        String string4 = bl11 ? null : tDNetworkIOIF.getOriginalHostName();
        String string5 = bl11 ? null : stringArray[0];
        String string6 = stringArray[1];
        List list5 = CertChecker.getCertHostNameProblems(x509Certificate, "Hostname", string4, tDNetworkIOIF.log);
        List list6 = CertChecker.getCertHostNameProblems(x509Certificate, "Resolved", string5, tDNetworkIOIF.log);
        List list7 = CertChecker.getCertHostNameProblems(x509Certificate, "IP Address", string6, tDNetworkIOIF.log);
        boolean bl12 = list5.isEmpty();
        boolean bl13 = list6.isEmpty();
        boolean bl14 = list7.isEmpty();
        CertRevStatus certRevStatus = new CertRevStatus();
        ArrayList arrayList = new ArrayList();
        if (tDNetworkIOIF.m_con.getURLParameters().getSSLModeLevel() == 6) {
            if (bl5 && !certRevStatus.known()) {
                CertChecker.checkRevocationStatus(tDNetworkIOIF, x509TrustManager4, x509CertificateArray, certRevStatus, arrayList);
            }
            if (bl6 && !certRevStatus.known()) {
                CertChecker.checkRevocationStatus(tDNetworkIOIF, x509TrustManager3, x509CertificateArray, certRevStatus, arrayList);
            }
            if (bl7 && !certRevStatus.known()) {
                CertChecker.checkRevocationStatus(tDNetworkIOIF, x509TrustManager2, x509CertificateArray, certRevStatus, arrayList);
            }
            if (bl8 && !certRevStatus.known()) {
                CertChecker.checkRevocationStatus(tDNetworkIOIF, x509TrustManager, x509CertificateArray, certRevStatus, arrayList);
            }
        }
        boolean bl15 = tDNetworkIOIF.m_con.getURLParameters().getSSLCRCSoftFail() ? !certRevStatus.revoked() : certRevStatus.good();
        boolean bl16 = bl2 = bl3 && (bl12 || bl14) && bl15;
        if (tDNetworkIOIF.log.isInfoEnabled()) {
            tDNetworkIOIF.log.info("SSLMODE=VERIFY-FULL would " + (bl2 ? "accept" : "reject") + " this connection");
        }
        connectThread.m_sCertStatus = (list.isEmpty() ? "V" : "I") + ",P" + (x509TrustManager4 == null ? "U" : (bl5 ? "A" : "R")) + ",D" + (x509TrustManager3 == null ? "U" : (bl6 ? "A" : "R")) + ",T" + (x509TrustManager2 == null ? "U" : (bl7 ? "A" : "R")) + ",J" + (x509TrustManager == null ? "U" : (bl8 ? "A" : "R")) + ",C" + (bl3 ? "Y" : "N") + ",H" + (bl11 ? "U" : (bl12 ? "Y" : "N")) + ",R" + (bl11 ? "U" : (bl13 ? "Y" : "N")) + ",I" + (bl14 ? "Y" : "N") + ",F" + (bl2 ? "Y" : "N") + ",S" + (certRevStatus.good() ? "G" : (certRevStatus.revoked() ? "R" : "U"));
        if (tDNetworkIOIF.log.isDebugEnabled()) {
            tDNetworkIOIF.log.debug("checkCert: t.m_sCertStatus=" + connectThread.m_sCertStatus);
        }
        boolean bl17 = tDNetworkIOIF.m_con.getURLParameters().getSSLModeLevel() == 5 && !bl3;
        boolean bl18 = bl = tDNetworkIOIF.m_con.getURLParameters().getSSLModeLevel() == 6 && !bl2;
        if (bl17 || bl) {
            ArrayList<CertificateException> arrayList2 = new ArrayList<CertificateException>(list);
            if (!bl4) {
                arrayList2.add(new CertificateException("No TrustManager available to verify certificate"));
            } else if (!bl9) {
                arrayList2.addAll((Collection<CertificateException>)object);
                arrayList2.addAll(list2);
                arrayList2.addAll(list3);
                arrayList2.addAll(list4);
            }
            if (bl) {
                arrayList2.addAll(list5);
                arrayList2.addAll(list7);
                arrayList2.addAll(arrayList);
            }
            throw CertChecker.makeIOException(tDNetworkIOIF.log, null, CertChecker.formatList(arrayList2, ", ", tDNetworkIOIF.m_con.getURLParameters().getSSLMode() + " error"));
        }
    }

    private static IOException makeIOException(Log log, Throwable throwable, String string) {
        log.error(string + (throwable == null ? "" : " caused by " + throwable));
        IOException iOException = new IOException(string);
        if (throwable != null) {
            iOException.initCause(throwable);
        }
        return iOException;
    }

    private static void checkRevocationStatus(TDNetworkIOIF tDNetworkIOIF, X509TrustManager x509TrustManager, X509Certificate[] x509CertificateArray, CertRevStatus certRevStatus, List list) throws IOException {
        PKIXParameters pKIXParameters;
        CertPathValidator certPathValidator;
        CertPath certPath;
        CertificateFactory certificateFactory;
        URLParameters uRLParameters = tDNetworkIOIF.m_con.getURLParameters();
        if (tDNetworkIOIF.log.isDebugEnabled()) {
            tDNetworkIOIF.log.debug("checkRevocationStatus: CRL=" + uRLParameters.getSSLCRL() + " OCSP=" + uRLParameters.getSSLOCSP() + " SoftFail=" + uRLParameters.getSSLCRCSoftFail() + " tm=" + x509TrustManager);
        }
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            list.add(new CertificateException("Cannot check certificate revocation status because server certificate is missing"));
            return;
        }
        X509Certificate[] x509CertificateArray2 = x509TrustManager.getAcceptedIssuers();
        if (x509CertificateArray2 == null || x509CertificateArray2.length == 0) {
            list.add(new CertificateException("Cannot check certificate revocation status because accepted issuers are not available"));
            return;
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            if (tDNetworkIOIF.log.isDebugEnabled()) {
                tDNetworkIOIF.log.debug("checkRevocationStatus: failed ex=" + certificateException);
            }
            list.add(certificateException);
            return;
        }
        try {
            certPath = certificateFactory.generateCertPath(Arrays.asList(x509CertificateArray));
        }
        catch (CertificateException certificateException) {
            if (tDNetworkIOIF.log.isDebugEnabled()) {
                tDNetworkIOIF.log.debug("checkRevocationStatus: failed ex=" + certificateException);
            }
            list.add(certificateException);
            return;
        }
        try {
            certPathValidator = CertPathValidator.getInstance("PKIX");
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (tDNetworkIOIF.log.isDebugEnabled()) {
                tDNetworkIOIF.log.debug("checkRevocationStatus: failed ex=" + generalSecurityException);
            }
            list.add(generalSecurityException);
            return;
        }
        PKIXRevocationChecker pKIXRevocationChecker = (PKIXRevocationChecker)certPathValidator.getRevocationChecker();
        if (uRLParameters.getSSLCRL() && uRLParameters.getSSLOCSP()) {
            pKIXRevocationChecker.setOptions(EnumSet.of(PKIXRevocationChecker.Option.SOFT_FAIL));
        } else if (uRLParameters.getSSLCRL()) {
            pKIXRevocationChecker.setOptions(EnumSet.of(PKIXRevocationChecker.Option.SOFT_FAIL, PKIXRevocationChecker.Option.PREFER_CRLS, PKIXRevocationChecker.Option.NO_FALLBACK));
        } else if (uRLParameters.getSSLOCSP()) {
            pKIXRevocationChecker.setOptions(EnumSet.of(PKIXRevocationChecker.Option.SOFT_FAIL, PKIXRevocationChecker.Option.NO_FALLBACK));
        } else {
            throw CertChecker.makeIOException(tDNetworkIOIF.log, null, "SSLCRL=OFF and SSLOCSP=OFF combination not permitted");
        }
        LinkedHashSet<TrustAnchor> linkedHashSet = new LinkedHashSet<TrustAnchor>();
        for (X509Certificate x509Certificate : x509CertificateArray2) {
            linkedHashSet.add(new TrustAnchor(x509Certificate, null));
        }
        try {
            pKIXParameters = new PKIXParameters(linkedHashSet);
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (tDNetworkIOIF.log.isDebugEnabled()) {
                tDNetworkIOIF.log.debug("checkRevocationStatus: failed ex=" + generalSecurityException);
            }
            list.add(generalSecurityException);
            return;
        }
        ArrayList<GeneralSecurityException> arrayList = new ArrayList<GeneralSecurityException>();
        pKIXParameters.addCertPathChecker(pKIXRevocationChecker);
        try {
            certPathValidator.validate(certPath, pKIXParameters);
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (generalSecurityException instanceof CertPathValidatorException && "Certificate does not specify OCSP responder".equals(generalSecurityException.getMessage())) {
                arrayList.add(generalSecurityException);
            }
            if (tDNetworkIOIF.log.isDebugEnabled()) {
                tDNetworkIOIF.log.debug("checkRevocationStatus: known to be revoked ex=" + generalSecurityException);
            }
            list.add(generalSecurityException);
            certRevStatus.setRevoked();
            return;
        }
        arrayList.addAll(pKIXRevocationChecker.getSoftFailExceptions());
        if (arrayList.isEmpty()) {
            certRevStatus.setGood();
        }
        if (tDNetworkIOIF.log.isDebugEnabled()) {
            tDNetworkIOIF.log.debug("checkRevocationStatus: CRL=" + uRLParameters.getSSLCRL() + " OCSP=" + uRLParameters.getSSLOCSP() + " SoftFail=" + uRLParameters.getSSLCRCSoftFail() + " status.good=" + certRevStatus.good() + " tm=" + x509TrustManager);
        }
        if (tDNetworkIOIF.log.isInfoEnabled()) {
            for (int i = 0; i < arrayList.size(); ++i) {
                tDNetworkIOIF.log.info("checkRevocationStatus " + (uRLParameters.getSSLCRCSoftFail() ? "ignored soft " : "") + "failure " + (i + 1) + " of " + arrayList.size() + ": " + arrayList.get(i));
            }
        }
        if (!uRLParameters.getSSLCRCSoftFail()) {
            list.addAll(arrayList);
        }
    }

    private static List getCertHostNameProblems(X509Certificate x509Certificate, String string, String string2, Log log) {
        ArrayList<CertificateException> arrayList = new ArrayList<CertificateException>();
        if (string2 == null) {
            arrayList.add(new CertificateException(string + " is not available to match Subject CN or SANs"));
        } else {
            boolean bl;
            String string3 = CertChecker.extractCNfromCert(x509Certificate);
            boolean bl2 = bl = string3 != null && CertChecker.matchesPatternIgnoreCase(string2, CertChecker.convertHostNamePatternToRegexPattern(string3));
            if (log.isInfoEnabled()) {
                log.info(string + " " + string2 + " " + (bl ? "matches" : "does not match") + " Subject CN" + (string3 != null ? " " + string3 : ""));
            }
            ExtractedSANs extractedSANs = CertChecker.extractSANsFromCert(x509Certificate);
            if (extractedSANs.ex != null && log.isInfoEnabled()) {
                log.info(string + " " + string2 + " extractSANsFromCert: " + extractedSANs.ex);
            }
            List list = CertChecker.findMatchingPatterns(string2, CertChecker.convertHostNamePatternsToRegexPatterns(extractedSANs.list));
            if (log.isInfoEnabled()) {
                log.info(string + " " + string2 + " " + (list.isEmpty() ? "does not match any SANs" : "matches SANs " + CertChecker.formatList(list, ", ", null)));
            }
            if (!bl && list.isEmpty()) {
                if (!bl) {
                    arrayList.add(new CertificateException(string + " " + string2 + (string3 != null ? " does not match Subject CN " + string3 : " cannnot match missing Subject CN")));
                }
                if (extractedSANs.ex != null) {
                    arrayList.add(extractedSANs.ex);
                }
                if (list.isEmpty()) {
                    arrayList.add(new CertificateException(string + " " + string2 + " does not match any SANs from certificate: " + extractedSANs.list));
                }
            }
        }
        return arrayList;
    }

    private static String convertHostNamePatternToRegexPattern(String string) {
        return string.replaceAll("[\\W]", "\\\\$0").replaceAll("\\\\\\*", "[^.]*");
    }

    private static List convertHostNamePatternsToRegexPatterns(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(CertChecker.convertHostNamePatternToRegexPattern((String)iterator.next()));
            }
        }
        return arrayList;
    }

    private static List findMatchingPatterns(String string, List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (String string2 : list) {
                if (!CertChecker.matchesPatternIgnoreCase(string, string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private static boolean matchesPatternIgnoreCase(String string, String string2) {
        return string.matches("(?i)" + string2);
    }

    private static X509TrustManager getDefaultTrustManager(Log log) {
        TrustManagerFactory trustManagerFactory;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (log.isInfoEnabled()) {
                log.info("Could not obtain default TrustManagerFactory: " + generalSecurityException);
            }
            return null;
        }
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray.length != 1 || !(trustManagerArray[0] instanceof X509TrustManager)) {
            if (log.isInfoEnabled()) {
                log.info("Could not obtain default X509TrustManager");
            }
            return null;
        }
        return (X509TrustManager)trustManagerArray[0];
    }

    private static X509TrustManager createTrustManagerFromPEMFiles(List list, Log log, String string) throws IOException {
        TrustManagerFactory trustManagerFactory;
        TrustManager[] trustManagerArray;
        CertificateFactory certificateFactory;
        if (list == null) {
            return null;
        }
        String[] stringArray = list.toArray(new String[0]);
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw CertChecker.makeIOException(log, certificateException, string + " Could not obtain X.509 certificate factory");
        }
        LinkedHashSet<TrustAnchor> linkedHashSet = new LinkedHashSet<TrustAnchor>();
        for (int i = 0; i < stringArray.length; ++i) {
            Collection<? extends Certificate> collection;
            FileInputStream fileInputStream;
            trustManagerArray = stringArray[i];
            try {
                fileInputStream = new FileInputStream((String)trustManagerArray);
            }
            catch (Exception exception) {
                throw CertChecker.makeIOException(log, exception, string + " Could not access server certificate file " + (String)trustManagerArray);
            }
            try {
                collection = certificateFactory.generateCertificates(fileInputStream);
            }
            catch (CertificateException certificateException) {
                throw CertChecker.makeIOException(log, certificateException, string + " Could not obtain server certificate from file " + (String)trustManagerArray);
            }
            finally {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
            if (collection.isEmpty()) {
                throw CertChecker.makeIOException(log, null, string + " Found no server certificate in file " + (String)trustManagerArray);
            }
            X509Certificate[] x509CertificateArray = collection.toArray(new X509Certificate[0]);
            for (int j = 0; j < x509CertificateArray.length; ++j) {
                linkedHashSet.add(new TrustAnchor(x509CertificateArray[j], null));
            }
        }
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(new CertPathTrustManagerParameters(new PKIXBuilderParameters(linkedHashSet, (CertSelector)new X509CertSelector())));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw CertChecker.makeIOException(log, generalSecurityException, string + " Could not obtain TrustManagerFactory for trusted certificates");
        }
        trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray.length != 1 || !(trustManagerArray[0] instanceof X509TrustManager)) {
            throw CertChecker.makeIOException(log, null, string + " Could not obtain X509TrustManager for trusted certificates");
        }
        return (X509TrustManager)trustManagerArray[0];
    }

    private static X509TrustManager createTrustManagerFromPEMFile(String string, Log log, String string2) throws IOException {
        if (string == null) {
            return null;
        }
        return CertChecker.createTrustManagerFromPEMFiles(Collections.singletonList(string), log, string2);
    }

    private static X509TrustManager createTrustManagerFromPEMDirectory(String string, Log log, String string2) throws IOException {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (!file.isDirectory()) {
            throw CertChecker.makeIOException(log, null, string2 + " Specified name " + string + " is not a directory");
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".pem");
            }
        };
        File[] fileArray = file.listFiles(filenameFilter);
        if (fileArray == null) {
            throw CertChecker.makeIOException(log, null, string2 + " Unable to access directory " + string);
        }
        if (fileArray.length == 0) {
            throw CertChecker.makeIOException(log, null, string2 + " No .pem files found in directory " + string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < fileArray.length; ++i) {
            arrayList.add(fileArray[i].toString());
        }
        return CertChecker.createTrustManagerFromPEMFiles(arrayList, log, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509TrustManager createTrustManagerFromTrustStoreFile(String string, Log log) throws IOException {
        TrustManagerFactory trustManagerFactory;
        KeyStore keyStore;
        FileInputStream fileInputStream;
        if (string == null) {
            return null;
        }
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (Exception exception) {
            throw CertChecker.makeIOException(log, exception, "Could not access TrustStore file " + string);
        }
        String string2 = KeyStore.getDefaultType();
        try {
            try {
                keyStore = KeyStore.getInstance(string2);
            }
            catch (KeyStoreException keyStoreException) {
                throw CertChecker.makeIOException(log, keyStoreException, "Could not obtain " + string2 + " key store");
            }
            try {
                keyStore.load(fileInputStream, null);
            }
            catch (Exception exception) {
                throw CertChecker.makeIOException(log, exception, "Could not load " + string2 + " TrustStore file " + string);
            }
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw CertChecker.makeIOException(log, generalSecurityException, "Could not obtain TrustManagerFactory");
        }
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray.length != 1 || !(trustManagerArray[0] instanceof X509TrustManager)) {
            throw CertChecker.makeIOException(log, null, "Could not obtain X509TrustManager for " + string2 + " key store");
        }
        return (X509TrustManager)trustManagerArray[0];
    }

    private static String formatDateRange(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return "not available";
        }
        return x509Certificate.getNotBefore() + " to " + x509Certificate.getNotAfter();
    }

    private static List getValidityProblems(X509Certificate[] x509CertificateArray) {
        ArrayList<CertificateException> arrayList = new ArrayList<CertificateException>();
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            arrayList.add(new CertificateException("Cannot check server certificate validity because server certificate is missing"));
        } else {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                try {
                    x509CertificateArray[i].checkValidity();
                    continue;
                }
                catch (CertificateException certificateException) {
                    arrayList.add(certificateException);
                }
            }
        }
        return arrayList;
    }

    private static String formatValidity(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return "validity is not available";
        }
        try {
            x509Certificate.checkValidity();
        }
        catch (CertificateException certificateException) {
            return "is invalid due to " + certificateException;
        }
        return "is valid";
    }

    private static String formatCertPurpose(X509Certificate x509Certificate) {
        boolean[] blArray;
        boolean[] blArray2 = blArray = x509Certificate != null ? x509Certificate.getKeyUsage() : null;
        if (blArray == null) {
            return "not available";
        }
        String[] stringArray = new String[]{"digitalSignature(0)", "nonRepudiation(1)", "keyEncipherment(2)", "dataEncipherment(3)", "keyAgreement(4)", "keyCertSign(5)", "cRLSign(6)", "encipherOnly(7)", "decipherOnly(8)"};
        String string = "";
        for (int i = 0; i < blArray.length; ++i) {
            string = string + (!blArray[i] ? "" : (string.length() > 0 ? ", " : "") + (i < stringArray.length ? stringArray[i] : "unknown(" + i + ")"));
        }
        return string;
    }

    private static String formatDN(X509Certificate x509Certificate) {
        Principal principal = x509Certificate != null ? x509Certificate.getSubjectDN() : null;
        String string = principal != null ? principal.getName() : null;
        return string != null ? string : "not available";
    }

    private static String extractCNfromDN(String string) {
        return string == null ? null : string.replaceAll("\\\\\\\\", "\u0019").replaceAll("\\\\,", "\u001c").replaceAll("\\\\;", "\u001d").replaceAll("\\\\\"", "\u001e").replaceAll("\\\\=", "\u001f").replaceAll("\"([^\"]*)\"", "\u0017$1\u0018").replaceAll("(\u0017[^\u0018]*)C(N\\s*=)", "$1\u0016$2").replaceFirst("(?s)(?:^|^.*[,;]\\s*)CN\\s*=\\s*(\u0017[^\u0018]*\u0018|[^,;]*).*", "$1").replaceFirst("\\s+$", "").replaceAll("\u0018", "").replaceAll("\u0016", "C").replaceAll("\u0017", "").replaceAll("\u001f", "=").replaceAll("\u001e", "\"").replaceAll("\u001d", ";").replaceAll("\u001c", ",").replaceAll("\\\\", "").replaceAll("\u0019", "\\\\");
    }

    private static String extractCNfromCert(X509Certificate x509Certificate) {
        Principal principal = x509Certificate != null ? x509Certificate.getSubjectDN() : null;
        String string = principal != null ? principal.getName() : null;
        return CertChecker.extractCNfromDN(string);
    }

    private static String formatCN(X509Certificate x509Certificate) {
        String string = CertChecker.extractCNfromCert(x509Certificate);
        return string != null ? string : "not available";
    }

    private static ExtractedSANs extractSANsFromCert(X509Certificate x509Certificate) {
        ExtractedSANs extractedSANs = new ExtractedSANs();
        Collection<List<?>> collection = null;
        if (x509Certificate != null) {
            try {
                collection = x509Certificate.getSubjectAlternativeNames();
            }
            catch (CertificateParsingException certificateParsingException) {
                extractedSANs.ex = certificateParsingException;
            }
        }
        if (collection != null) {
            extractedSANs.list = new ArrayList();
            List<Object> list = Arrays.asList(new Integer(2), new Integer(7));
            for (List<?> list2 : collection) {
                if (list2.size() < 2 || !list.contains(list2.get(0)) || !(list2.get(1) instanceof String)) continue;
                extractedSANs.list.add(list2.get(1));
            }
        }
        return extractedSANs;
    }

    private static String formatList(List list, String string, String string2) {
        if (list == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (string != null && stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            if (string2 != null) {
                stringBuffer.append(string2).append(" " + n + " of " + list.size() + ": ");
            }
            stringBuffer.append(String.valueOf(iterator.next()));
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String formatSANs(X509Certificate x509Certificate) {
        ExtractedSANs extractedSANs = CertChecker.extractSANsFromCert(x509Certificate);
        if (extractedSANs.ex != null) {
            return "not available: " + extractedSANs.ex;
        }
        if (extractedSANs.list == null) {
            return "not present";
        }
        return CertChecker.formatList(extractedSANs.list, ", ", null);
    }

    private static String formatCert(Certificate certificate) {
        return "  ----------------------------------------------\n  |  " + String.valueOf(certificate).trim().replaceAll("\n", "\n  |  ") + "\n" + "  ----------------------------------------------";
    }

    private static List getServerCertProblems(X509TrustManager x509TrustManager, X509Certificate[] x509CertificateArray, String string) {
        ArrayList<CertificateException> arrayList = new ArrayList<CertificateException>();
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            arrayList.add(new CertificateException(string + " TrustManager cannot check server certificate validity because server certificate is missing"));
        } else if (x509TrustManager != null) {
            try {
                x509TrustManager.checkServerTrusted(x509CertificateArray, "UNKNOWN");
            }
            catch (CertificateException certificateException) {
                arrayList.add(new CertificateException(string + " TrustManager rejected certificate"));
                arrayList.add(certificateException);
            }
        }
        return arrayList;
    }

    private static Set setMinus(Collection collection, Collection collection2) {
        LinkedHashSet linkedHashSet = new LinkedHashSet(collection);
        linkedHashSet.removeAll(collection2);
        return linkedHashSet;
    }

    private static class ExtractedSANs {
        public List list = null;
        public CertificateParsingException ex = null;
    }

    private static class CertRevStatus {
        private boolean bGood;
        private boolean bRevoked;

        public void setGood() {
            this.bGood = true;
        }

        public void setRevoked() {
            this.bRevoked = true;
        }

        public boolean good() {
            return this.bGood;
        }

        public boolean revoked() {
            return this.bRevoked;
        }

        public boolean known() {
            return this.bGood || this.bRevoked;
        }
    }
}

