/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.LocatorClob;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.sql.SQLException;

public class ClobWriter
extends Writer {
    private LocatorClob clob;

    public ClobWriter(LocatorClob locatorClob) {
        this.clob = locatorClob;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.clob = null;
    }

    public void write(char c) throws IOException {
        this.write(new char[]{c});
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.clob == null) {
            throw new IOException(ErrorMessage.messages.getString("TJ550"));
        }
        try {
            StringReader stringReader = new StringReader(new String(cArray, n, n2));
            this.clob.writeStream(this.clob.length() + 1L, stringReader, n2);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getErrorCode() + ": " + sQLException);
        }
    }
}

