/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.map.remote.core.design.kml.impl;

import bpm.vanilla.map.core.communication.xml.XmlAction;
import bpm.vanilla.map.core.communication.xml.XmlArgumentsHolder;
import bpm.vanilla.map.core.design.kml.IKmlManipulator;
import bpm.vanilla.map.core.design.kml.IKmlObject;
import bpm.vanilla.map.core.design.kml.IKmlRegistry;
import bpm.vanilla.map.core.design.kml.KmlColoringDatas;
import bpm.vanilla.map.remote.internal.HttpCommunicator;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.extended.EncodedByteArrayConverter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;

public class RemoteKmlRegistry
implements IKmlRegistry,
IKmlManipulator {
    private HttpCommunicator httpCommunicator = new HttpCommunicator("");
    private XStream xstream;

    public RemoteKmlRegistry() {
        this.init();
    }

    public void configure(Object config) {
        this.setVanillaRuntimeUrl((String)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVanillaRuntimeUrl(String vanillaRuntimeUrl) {
        HttpCommunicator httpCommunicator = this.httpCommunicator;
        synchronized (httpCommunicator) {
            this.httpCommunicator.setUrl(vanillaRuntimeUrl);
        }
    }

    private void init() {
        this.xstream = new XStream();
        this.xstream.registerConverter((SingleValueConverter)new EncodedByteArrayConverter());
    }

    private XmlArgumentsHolder createArguments(Object ... arguments) {
        XmlArgumentsHolder args = new XmlArgumentsHolder();
        int i = 0;
        while (i < arguments.length) {
            args.addArgument(arguments[i]);
            ++i;
        }
        return args;
    }

    public IKmlObject addKmlObject(IKmlObject kmlObject, InputStream kmlInputStream) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int sz = 0;
        while ((sz = kmlInputStream.read(buffer, 0, 1024)) != -1) {
            bos.write(buffer, 0, sz);
        }
        kmlInputStream.close();
        bos.close();
        XmlAction op = new XmlAction(this.createArguments(kmlObject, bos.toByteArray()), XmlAction.ActionType.KML_SAVE);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IKmlObject)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public IKmlObject getKmlObject(Integer kmlObjectId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(kmlObjectId), XmlAction.ActionType.KML_GET);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IKmlObject)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<IKmlObject> getKmlObjects() throws Exception {
        XmlAction op = new XmlAction(this.createArguments(new Object[0]), XmlAction.ActionType.KML_GET);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void removeKmlObject(IKmlObject kmlObject) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(kmlObject), XmlAction.ActionType.KML_DELETE);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void removeKmlObject(Integer kmlObjectId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(kmlObjectId), XmlAction.ActionType.KML_DELETE);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String getKmlFolderLocation() {
        return null;
    }

    public String generateKml(String originalKmlUrl, KmlColoringDatas coloringDatas) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(originalKmlUrl, coloringDatas), XmlAction.ActionType.KML_GENERATE);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (String)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

