/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.map.remote.core.design.impl;

import bpm.vanilla.map.core.communication.xml.XmlAction;
import bpm.vanilla.map.core.communication.xml.XmlArgumentsHolder;
import bpm.vanilla.map.core.design.IOpenGisMapService;
import bpm.vanilla.map.core.design.opengis.IOpenGisCoordinate;
import bpm.vanilla.map.core.design.opengis.IOpenGisMapEntity;
import bpm.vanilla.map.core.design.opengis.IOpenGisMapObject;
import bpm.vanilla.map.remote.internal.HttpCommunicator;
import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class RemoteOpenGisMapService
implements IOpenGisMapService {
    private HttpCommunicator httpCommunicator = new HttpCommunicator("");
    private XStream xstream;

    public RemoteOpenGisMapService() {
        this.init();
    }

    public void configure(Object config) {
        this.setVanillaRuntimeUrl((String)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVanillaRuntimeUrl(String vanillaRuntimeUrl) {
        HttpCommunicator httpCommunicator = this.httpCommunicator;
        synchronized (httpCommunicator) {
            this.httpCommunicator.setUrl(vanillaRuntimeUrl);
        }
    }

    private void init() {
        this.xstream = new XStream();
    }

    private XmlArgumentsHolder createArguments(Object ... arguments) {
        XmlArgumentsHolder args = new XmlArgumentsHolder();
        int i = 0;
        while (i < arguments.length) {
            args.addArgument(arguments[i]);
            ++i;
        }
        return args;
    }

    public void addOpenGisMap(IOpenGisMapObject map) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(map), XmlAction.ActionType.ADD_MAP);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void deleteOpenGisMap(IOpenGisMapObject map) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(map), XmlAction.ActionType.REMOVE_MAP);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public IOpenGisMapObject getOpenGisMapById(int mapId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(mapId), XmlAction.ActionType.GET_MAP_BY_ID);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IOpenGisMapObject)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<IOpenGisMapEntity> getOpenGisMapEntities(IOpenGisMapObject map) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(map), XmlAction.ActionType.GET_MAP_ENTITIES);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<IOpenGisMapObject> getOpenGisMaps() throws Exception {
        XmlAction op = new XmlAction(this.createArguments(new Object[0]), XmlAction.ActionType.GET_MAPS);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void updateOpenGisMap(IOpenGisMapObject map) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(map), XmlAction.ActionType.UPDATE_MAP);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void addOpenGisMap(IOpenGisMapObject map, InputStream fileShape) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int sz = 0;
        byte[] buf = new byte[1024];
        while ((sz = fileShape.read(buf)) >= 0) {
            bos.write(buf, 0, sz);
        }
        fileShape.close();
        byte[] streamDatas = Base64.encodeBase64((byte[])bos.toByteArray());
        XmlAction op = new XmlAction(this.createArguments(map, streamDatas), XmlAction.ActionType.ADD_MAP_SHAPE);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }

    public List<IOpenGisCoordinate> getOpenGisCoordinates(int entityId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(entityId), XmlAction.ActionType.GET_ENTITY_COORDINATES);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public IOpenGisMapObject getOpenGisMapByDefinitionId(int mapDefinitionId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(mapDefinitionId), XmlAction.ActionType.GET_MAP_BY_DEFINITION_ID);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IOpenGisMapObject)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void saveShapeFile(int openGisMapId, InputStream fileShape) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int sz = 0;
        byte[] buf = new byte[1024];
        while ((sz = fileShape.read(buf)) >= 0) {
            bos.write(buf, 0, sz);
        }
        fileShape.close();
        byte[] streamDatas = Base64.encodeBase64((byte[])bos.toByteArray());
        XmlAction op = new XmlAction(this.createArguments(openGisMapId, streamDatas), XmlAction.ActionType.SAVE_SHAPE);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }
}

