/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.map.remote.core.design.impl;

import bpm.vanilla.map.core.communication.xml.XmlAction;
import bpm.vanilla.map.core.communication.xml.XmlArgumentsHolder;
import bpm.vanilla.map.core.design.fusionmap.IFusionMapObject;
import bpm.vanilla.map.core.design.fusionmap.IFusionMapRegistry;
import bpm.vanilla.map.remote.internal.HttpCommunicator;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.extended.EncodedByteArrayConverter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;

public class RemoteFusionMapRegistry
implements IFusionMapRegistry {
    private HttpCommunicator httpCommunicator = new HttpCommunicator("");
    private XStream xstream;

    public RemoteFusionMapRegistry() {
        this.init();
    }

    public void configure(Object config) {
        this.setVanillaRuntimeUrl((String)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVanillaRuntimeUrl(String vanillaRuntimeUrl) {
        HttpCommunicator httpCommunicator = this.httpCommunicator;
        synchronized (httpCommunicator) {
            this.httpCommunicator.setUrl(vanillaRuntimeUrl);
        }
    }

    private void init() {
        this.xstream = new XStream();
        this.xstream.registerConverter((SingleValueConverter)new EncodedByteArrayConverter());
    }

    private XmlArgumentsHolder createArguments(Object ... arguments) {
        XmlArgumentsHolder args = new XmlArgumentsHolder();
        int i = 0;
        while (i < arguments.length) {
            args.addArgument(arguments[i]);
            ++i;
        }
        return args;
    }

    public IFusionMapObject addFusionMapObject(IFusionMapObject fusionMap, InputStream swfInputStream) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int sz = 0;
        while ((sz = swfInputStream.read(buffer, 0, 1024)) != -1) {
            bos.write(buffer, 0, sz);
        }
        swfInputStream.close();
        bos.close();
        XmlAction op = new XmlAction(this.createArguments(fusionMap, bos.toByteArray()), XmlAction.ActionType.FUSION_MAP_SAVE);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IFusionMapObject)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public IFusionMapObject getFusionMapObject(long fusionMapObjectId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(fusionMapObjectId), XmlAction.ActionType.FUSION_MAP_GET);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IFusionMapObject)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<IFusionMapObject> getFusionMapObjects() throws Exception {
        XmlAction op = new XmlAction(this.createArguments(new Object[0]), XmlAction.ActionType.FUSION_MAP_GET);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void removeFusionMapObject(IFusionMapObject fusionMap) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(fusionMap), XmlAction.ActionType.FUSION_MAP_DELETE);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void removeFusionMapObject(long fusionMapObjectId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(fusionMapObjectId), XmlAction.ActionType.FUSION_MAP_DELETE);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String getMapFolderLocation() {
        return null;
    }

    public List<IFusionMapObject> getFusionMapObjects(String type) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(type), XmlAction.ActionType.FUSION_MAP_GET);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

