/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.map.remote.core.design.fusionmap.impl;

import bpm.vanilla.map.core.communication.xml.XmlAction;
import bpm.vanilla.map.core.communication.xml.XmlArgumentsHolder;
import bpm.vanilla.map.core.design.IAddress;
import bpm.vanilla.map.core.design.IAddressMapDefinitionRelation;
import bpm.vanilla.map.core.design.IAddressRelation;
import bpm.vanilla.map.core.design.IAddressZone;
import bpm.vanilla.map.core.design.IBuilding;
import bpm.vanilla.map.core.design.IBuildingFloor;
import bpm.vanilla.map.core.design.ICell;
import bpm.vanilla.map.core.design.IImage;
import bpm.vanilla.map.core.design.IMapDefinition;
import bpm.vanilla.map.core.design.IMapDefinitionRelation;
import bpm.vanilla.map.core.design.IMapDefinitionService;
import bpm.vanilla.map.core.design.IZoneTerritoryMapping;
import bpm.vanilla.map.core.design.MapDataSet;
import bpm.vanilla.map.core.design.MapDataSource;
import bpm.vanilla.map.core.design.MapLayer;
import bpm.vanilla.map.core.design.MapServer;
import bpm.vanilla.map.core.design.MapVanilla;
import bpm.vanilla.map.core.design.MapZone;
import bpm.vanilla.map.core.design.ZoneMetadataMapping;
import bpm.vanilla.map.core.design.openlayers.IOpenLayersMapObject;
import bpm.vanilla.map.remote.internal.HttpCommunicator;
import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RemoteMapDefinitionService
implements IMapDefinitionService {
    private HttpCommunicator httpCommunicator = new HttpCommunicator("");
    private XStream xstream;

    public RemoteMapDefinitionService() {
        this.init();
    }

    public void configure(Object config) {
        this.setVanillaRuntimeUrl((String)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVanillaRuntimeUrl(String vanillaRuntimeUrl) {
        HttpCommunicator httpCommunicator = this.httpCommunicator;
        synchronized (httpCommunicator) {
            this.httpCommunicator.setUrl(vanillaRuntimeUrl);
        }
    }

    private void init() {
        this.xstream = new XStream();
    }

    private XmlArgumentsHolder createArguments(Object ... arguments) {
        XmlArgumentsHolder args = new XmlArgumentsHolder();
        int i = 0;
        while (i < arguments.length) {
            args.addArgument(arguments[i]);
            ++i;
        }
        return args;
    }

    public void delete(IAddress address) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(address), XmlAction.ActionType.DEF_DELETE);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }

    public void delete(IBuilding building) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(building), XmlAction.ActionType.DEF_DELETE);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }

    public void delete(IBuildingFloor floor) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(floor), XmlAction.ActionType.DEF_DELETE);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }

    public void delete(ICell cell) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(cell), XmlAction.ActionType.DEF_DELETE);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }

    public void delete(IMapDefinition mapDefinition) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(mapDefinition), XmlAction.ActionType.DEF_DELETE);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }

    public IAddress getAddress(int addressId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(addressId), XmlAction.ActionType.GET_ADDRESS);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IAddress)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<IAddress> getAllAddress() throws Exception {
        XmlAction op = new XmlAction(this.createArguments(new Object[0]), XmlAction.ActionType.GET_ADDRESS);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<IBuilding> getAllBuilding() throws Exception {
        XmlAction op = new XmlAction(this.createArguments(new Object[0]), XmlAction.ActionType.GET_BUILDING);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            if (xml == null || xml.equals("")) {
                return new ArrayList<IBuilding>();
            }
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<ICell> getAllCell() throws Exception {
        XmlAction op = new XmlAction(this.createArguments(new Object[0]), XmlAction.ActionType.GET_CELL);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<IBuildingFloor> getAllFloor() throws Exception {
        XmlAction op = new XmlAction(this.createArguments(new Object[0]), XmlAction.ActionType.GET_FLOOR);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<IImage> getAllImage() throws Exception {
        XmlAction op = new XmlAction(this.createArguments(new Object[0]), XmlAction.ActionType.GET_IMAGE);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<IMapDefinition> getAllMapDefinition() throws Exception {
        XmlAction op = new XmlAction(this.createArguments(new Object[0]), XmlAction.ActionType.GET_MAP_DEFINITION);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            if (xml == null || xml.equals("")) {
                return new ArrayList<IMapDefinition>();
            }
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public IBuilding getBuilding(int buildingId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(buildingId), XmlAction.ActionType.GET_BUILDING);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IBuilding)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<IBuilding> getBuildingsForAddress(int addressId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments("addressId", addressId), XmlAction.ActionType.GET_BUILDING);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public ICell getCell(int cellId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(cellId), XmlAction.ActionType.GET_CELL);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (ICell)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<ICell> getCellsForBuilding(int buildingId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments("buildingId", buildingId), XmlAction.ActionType.GET_CELL);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<ICell> getCellsForFloor(int floorId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments("floorId", floorId), XmlAction.ActionType.GET_CELL);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public IBuildingFloor getFloor(int floorId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(floorId), XmlAction.ActionType.GET_FLOOR);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IBuildingFloor)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<IBuildingFloor> getFloorsForBuilding(int buildingId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments("buildingId", buildingId), XmlAction.ActionType.GET_FLOOR);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public IImage getImage(int imageId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(imageId), XmlAction.ActionType.GET_IMAGE);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IImage)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public IMapDefinition getMapDefinition(int mapDefinitionId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(mapDefinitionId), XmlAction.ActionType.GET_MAP_DEFINITION);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IMapDefinition)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<IMapDefinition> getMapDefinitionFromAddressId(int addressId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments("addressId", addressId), XmlAction.ActionType.GET_MAP_DEFINITION);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public IAddress saveAddress(IAddress address) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(address), XmlAction.ActionType.DEF_SAVE);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IAddress)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public IBuilding saveBuilding(IBuilding building) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(building), XmlAction.ActionType.DEF_SAVE);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IBuilding)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public ICell saveCell(ICell cell) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(cell), XmlAction.ActionType.DEF_SAVE);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (ICell)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public IBuildingFloor saveFloor(IBuildingFloor floor) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(floor), XmlAction.ActionType.DEF_SAVE);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IBuildingFloor)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public IImage saveImage(IImage img) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(img), XmlAction.ActionType.DEF_SAVE);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IImage)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public IMapDefinition saveMapDefinition(IMapDefinition mapDef) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(mapDef), XmlAction.ActionType.DEF_SAVE);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IMapDefinition)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void update(IAddress address) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(address), XmlAction.ActionType.DEF_UPDATE);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void update(IBuilding building) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(building), XmlAction.ActionType.DEF_UPDATE);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void update(IBuildingFloor floor) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(floor), XmlAction.ActionType.DEF_UPDATE);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void update(ICell cell) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(cell), XmlAction.ActionType.DEF_UPDATE);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void update(IMapDefinition mapDefinition) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(mapDefinition), XmlAction.ActionType.DEF_UPDATE);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void delete(IAddressRelation relation) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(relation), XmlAction.ActionType.DEF_DELETE);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }

    public List<IAddress> getAddressChild(IAddress addressParent) throws Exception {
        XmlAction op = new XmlAction(this.createArguments("child", addressParent), XmlAction.ActionType.GET_ADDRESS);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<IAddress> getAddressParent() throws Exception {
        XmlAction op = new XmlAction(this.createArguments("parent", ""), XmlAction.ActionType.GET_ADDRESS);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public IAddressRelation saveAddressRelation(IAddressRelation relation) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(relation), XmlAction.ActionType.DEF_SAVE);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IAddressRelation)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void update(IAddressRelation relation) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(relation), XmlAction.ActionType.DEF_UPDATE);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void delete(IAddressZone addressZoneRelation) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(addressZoneRelation), XmlAction.ActionType.DEF_DELETE);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }

    public IAddressZone saveAddressZone(IAddressZone addressZoneRelation) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(addressZoneRelation), XmlAction.ActionType.DEF_SAVE);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IAddressZone)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void update(IAddressZone addressZoneRelation) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(addressZoneRelation), XmlAction.ActionType.DEF_UPDATE);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public IAddressZone getAddressZoneByZoneAndAddressId(int addressId, long zoneId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(addressId, zoneId), XmlAction.ActionType.GET_ADDRESS_ZONE);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IAddressZone)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public IAddress getAddressByLabel(String label) throws Exception {
        String xml;
        block3: {
            XmlAction op = new XmlAction(this.createArguments("label", label), XmlAction.ActionType.GET_ADDRESS);
            try {
                xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
                if (!xml.equals("") && xml != null) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        return (IAddress)this.xstream.fromXML(xml);
    }

    public List<IMapDefinition> getMapDefinitionChild(IMapDefinition mapDefinitionParent) throws Exception {
        XmlAction op = new XmlAction(this.createArguments("child", mapDefinitionParent), XmlAction.ActionType.GET_MAP_DEFINITION);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<IMapDefinition> getMapDefinitionParent() throws Exception {
        XmlAction op = new XmlAction(this.createArguments("parent", ""), XmlAction.ActionType.GET_MAP_DEFINITION);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void delete(IMapDefinitionRelation relation) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(relation), XmlAction.ActionType.DEF_DELETE);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }

    public IMapDefinitionRelation saveMapDefinitionRelation(IMapDefinitionRelation relation) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(relation), XmlAction.ActionType.DEF_SAVE);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IMapDefinitionRelation)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void update(IMapDefinitionRelation relation) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(relation), XmlAction.ActionType.DEF_UPDATE);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void delete(IAddressMapDefinitionRelation addressMapDefinitionRelation) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(addressMapDefinitionRelation), XmlAction.ActionType.DEF_DELETE);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }

    public IAddressMapDefinitionRelation saveAddressMapDefinitionRelation(IAddressMapDefinitionRelation addressMapDefinitionRelation) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(addressMapDefinitionRelation), XmlAction.ActionType.DEF_SAVE);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IAddressMapDefinitionRelation)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void update(IAddressMapDefinitionRelation addressMapDefinitionRelation) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(addressMapDefinitionRelation), XmlAction.ActionType.DEF_UPDATE);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public IAddressMapDefinitionRelation getAddressMapRelationByMapIdAndAddressId(int addressId, int mapId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(addressId, mapId), XmlAction.ActionType.GET_ADDRESS_MAP_DEFINITION_RELATION);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (IAddressMapDefinitionRelation)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<IZoneTerritoryMapping> getZoneTerritoryMappingByMapId(int mapId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(mapId), XmlAction.ActionType.GET_ZTMAPPING);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void saveZoneTerritoryMapping(IZoneTerritoryMapping zoneTerritoryMapping) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(zoneTerritoryMapping), XmlAction.ActionType.SAVE_ZTMAPPING);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }

    public void saveZoneTerritoryMappings(List<IZoneTerritoryMapping> zoneTerritoryMapping) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(zoneTerritoryMapping), XmlAction.ActionType.SAVE_ZTMAPPING);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }

    public void deleteZoneTerritoryMapping(IZoneTerritoryMapping zoneTerritoryMapping) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(zoneTerritoryMapping), XmlAction.ActionType.DEL_ZTMAPPING);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }

    public void deleteZoneTerritoryMappings(List<IZoneTerritoryMapping> zoneTerritoryMapping) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(zoneTerritoryMapping), XmlAction.ActionType.DEL_ZTMAPPING);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }

    public IOpenLayersMapObject getOpenLayersMapObject(Integer id) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(id), XmlAction.ActionType.GET_OLMO);
        String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        return (IOpenLayersMapObject)this.xstream.fromXML(xml);
    }

    public void saveOpenLayersMapObject(IOpenLayersMapObject openLayersMapObject) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(openLayersMapObject), XmlAction.ActionType.SAVE_OLMO);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }

    public List<IOpenLayersMapObject> getOpenLayersMapObjects() throws Exception {
        XmlAction op = new XmlAction(this.createArguments(new Object[0]), XmlAction.ActionType.GET_OLMO);
        String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        return (List)this.xstream.fromXML(xml);
    }

    public void deleteOpenLayersMap(IOpenLayersMapObject openLayersMap) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(openLayersMap), XmlAction.ActionType.DEL_OLMO);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }

    public List<IMapDefinition> getMapDefinition(IMapDefinitionService.MapType type) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(type), XmlAction.ActionType.GET_MAP_BY_TYPE);
        String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        return (List)this.xstream.fromXML(xml);
    }

    public List<MapVanilla> getMapVanillaById(Integer id) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(id), XmlAction.ActionType.GET_MAP_VANILLA_BY_ID);
        String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        return (List)this.xstream.fromXML(xml);
    }

    public List<MapVanilla> getAllMapsVanilla() throws Exception {
        XmlAction op = new XmlAction(this.createArguments(new Object[0]), XmlAction.ActionType.GET_MAPS_VANILLA_LIST);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            if (xml == null || xml.equals("")) {
                return new ArrayList<MapVanilla>();
            }
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public MapVanilla saveMapVanilla(MapVanilla map) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(map), XmlAction.ActionType.SAVE_MAP_VANILLA);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (MapVanilla)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void deleteMapVanilla(MapVanilla map) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(map), XmlAction.ActionType.DELETE_MAP_VANILLA);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }

    public void updateMapVanilla(MapVanilla map) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(map), XmlAction.ActionType.UPDATE_MAP_VANILLA);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<MapDataSource> getAllMapsDataSource() throws Exception {
        XmlAction op = new XmlAction(this.createArguments(new Object[0]), XmlAction.ActionType.GET_MAPS_DATASOURCE);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            if (xml == null || xml.equals("")) {
                return new ArrayList<MapDataSource>();
            }
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public MapDataSet saveMapDataSet(MapDataSet dtS) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(dtS), XmlAction.ActionType.SAVE_MAP_DATASET);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            return (MapDataSet)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<MapDataSet> getAllMapsDataSet() throws Exception {
        XmlAction op = new XmlAction(this.createArguments(new Object[0]), XmlAction.ActionType.GET_MAPS_DATASET);
        try {
            String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
            if (xml == null || xml.equals("")) {
                return new ArrayList<MapDataSet>();
            }
            return (List)this.xstream.fromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<MapDataSource> getMapDataSourceByName(String name) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(name), XmlAction.ActionType.GET_MAP_DATASOURCE_BY_NAME);
        String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        return (List)this.xstream.fromXML(xml);
    }

    public void deleteMapDataSet(MapDataSet dtS) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(dtS), XmlAction.ActionType.DELETE_MAP_DATASET);
        this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
    }

    public List<MapDataSet> getMapDataSetByMapVanillaId(Integer id) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(id), XmlAction.ActionType.GET_MAP_DATASET_BY_MAPVANILLA_ID);
        String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        return (List)this.xstream.fromXML(xml);
    }

    public List<MapDataSource> getMapDataSourceById(Integer id) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(id), XmlAction.ActionType.GET_MAP_DATASOURCE_BY_ID);
        String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        return (List)this.xstream.fromXML(xml);
    }

    public void updateMapDataSource(MapDataSource dtS) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(dtS), XmlAction.ActionType.UPDATE_MAP_DATASOURCE);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void updateMapDataSet(MapDataSet dtS) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(dtS), XmlAction.ActionType.UPDATE_MAP_DATASET);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<MapDataSet> getMapDataSetById(Integer id) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(id), XmlAction.ActionType.GET_MAPDATASET_BY_ID);
        String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        return (List)this.xstream.fromXML(xml);
    }

    public List<MapServer> getMapServers() throws Exception {
        XmlAction op = new XmlAction(this.createArguments(new Object[0]), XmlAction.ActionType.GET_MAP_SERVERS);
        String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        return (List)this.xstream.fromXML(xml);
    }

    public List<MapLayer> getLayers(MapServer server) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(server), XmlAction.ActionType.GET_MAP_LAYERS);
        String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        return (List)this.xstream.fromXML(xml);
    }

    public MapServer manageMapServer(MapServer server, IMapDefinitionService.ManageAction action) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(server, action), XmlAction.ActionType.MANAGE_MAP_SERVER);
        String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        return (MapServer)this.xstream.fromXML(xml);
    }

    public List<MapServer> getArcgisServices(MapServer server) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(server), XmlAction.ActionType.GET_ARCGIS_SERVICES);
        String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        return (List)this.xstream.fromXML(xml);
    }

    public Map<String, Map<Integer, ZoneMetadataMapping>> getMetadataMappings(int id) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(id), XmlAction.ActionType.GET_METADATA_MAPPINGS);
        String xml = this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        return (Map)this.xstream.fromXML(xml);
    }

    public void saveMetadataMappingsFromZones(List<MapZone> zones, MapVanilla map) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(zones, map), XmlAction.ActionType.SAVE_METADATA_MAPPINGS);
        try {
            this.httpCommunicator.executeAction(op, this.xstream.toXML((Object)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

