/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleDatumWithConnection;

public abstract class Datum
implements Serializable {
    private byte[] data;
    protected Datum targetDatum = null;
    protected OracleDatumWithConnection ojiOracleDatumWithConnection = null;
    static final long serialVersionUID = 4645732484621936751L;

    public Datum() {
    }

    public Datum(byte[] newData) {
        this.data = newData;
    }

    public boolean equals(Object obj) {
        if (this.targetDatum != null) {
            if (!this.targetDatum.equals(obj)) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || !(obj instanceof Datum)) {
                    return false;
                }
                if (this.getClass() == obj.getClass()) {
                    Datum od = (Datum)obj;
                    byte[] tempData = this.targetDatum.shareBytes();
                    if (tempData == null && od.data == null) {
                        return true;
                    }
                    if (tempData == null && od.data != null || tempData != null && od.data == null) {
                        return false;
                    }
                    if (tempData.length != od.data.length) {
                        return false;
                    }
                    for (int i = 0; i < tempData.length; ++i) {
                        if (tempData[i] == od.data[i]) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return true;
        }
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Datum)) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            Datum od = (Datum)obj;
            if (this.data == null && od.data == null) {
                return true;
            }
            if (this.data == null && od.data != null || this.data != null && od.data == null) {
                return false;
            }
            if (this.data.length != od.data.length) {
                return false;
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == od.data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int bytesHashCode() {
        if (this.targetDatum != null) {
            return this.targetDatum.bytesHashCode();
        }
        int h = 1;
        if (this.data != null && this.data.length > 0) {
            for (int i = 0; i < this.data.length; ++i) {
                h = 31 * h + this.data[i];
            }
        }
        return h;
    }

    public byte[] shareBytes() {
        if (this.ojiOracleDatumWithConnection != null) {
            return this.ojiOracleDatumWithConnection.shareBytes();
        }
        if (this.targetDatum != null) {
            return this.targetDatum.shareBytes();
        }
        return this.data;
    }

    public long getLength() {
        if (this.ojiOracleDatumWithConnection != null) {
            return this.ojiOracleDatumWithConnection.getLength();
        }
        if (this.targetDatum != null) {
            return this.targetDatum.getLength();
        }
        if (null == this.data) {
            return 0L;
        }
        return this.data.length;
    }

    public void setBytes(byte[] array) {
        if (this.ojiOracleDatumWithConnection != null) {
            this.ojiOracleDatumWithConnection.setBytes(array);
        } else if (this.targetDatum != null) {
            this.targetDatum.setBytes(array);
        } else {
            int length = array.length;
            this.data = new byte[length];
            System.arraycopy(array, 0, this.data, 0, length);
        }
    }

    public void setShareBytes(byte[] array) {
        if (this.ojiOracleDatumWithConnection != null) {
            this.ojiOracleDatumWithConnection.setShareBytes(array);
        } else if (this.targetDatum != null) {
            this.targetDatum.setShareBytes(array);
        } else {
            this.data = array;
        }
    }

    public byte[] getBytes() {
        if (this.ojiOracleDatumWithConnection != null) {
            return this.ojiOracleDatumWithConnection.getBytes();
        }
        if (this.targetDatum != null) {
            return this.targetDatum.getBytes();
        }
        if (this.data == null) {
            return new byte[0];
        }
        byte[] tmp = new byte[this.data.length];
        System.arraycopy(this.data, 0, tmp, 0, this.data.length);
        return tmp;
    }

    public boolean isNull() {
        if (this.targetDatum != null) {
            return this.targetDatum.isNull();
        }
        return this.data == null || this.data.length == 0;
    }

    public InputStream getStream() {
        if (this.targetDatum != null) {
            return this.targetDatum.getStream();
        }
        return new ByteArrayInputStream(this.data);
    }

    public String stringValue() throws SQLException {
        throw new SQLException("Conversion to String failed");
    }

    public String stringValue(Connection conn) throws SQLException {
        return this.stringValue();
    }

    public boolean booleanValue() throws SQLException {
        throw new SQLException("Conversion to boolean failed");
    }

    public int intValue() throws SQLException {
        throw new SQLException("Conversion to integer failed");
    }

    public long longValue() throws SQLException {
        throw new SQLException("Conversion to long failed");
    }

    public float floatValue() throws SQLException {
        throw new SQLException("Conversion to float failed");
    }

    public double doubleValue() throws SQLException {
        throw new SQLException("Conversion to double failed");
    }

    public byte byteValue() throws SQLException {
        throw new SQLException("Conversion to byte failed");
    }

    public BigDecimal bigDecimalValue() throws SQLException {
        throw new SQLException("Conversion to BigDecimal failed");
    }

    public Date dateValue() throws SQLException {
        throw new SQLException("Conversion to Date failed");
    }

    public Time timeValue() throws SQLException {
        throw new SQLException("Conversion to Time failed");
    }

    public Time timeValue(Calendar cal) throws SQLException {
        throw new SQLException("Conversion to Time failed");
    }

    public Timestamp timestampValue() throws SQLException {
        throw new SQLException("Conversion to Timestamp failed");
    }

    public Timestamp timestampValue(Calendar cal) throws SQLException {
        throw new SQLException("Conversion to Timestamp failed");
    }

    public Reader characterStreamValue() throws SQLException {
        throw new SQLException("Conversion to character stream failed");
    }

    public InputStream asciiStreamValue() throws SQLException {
        throw new SQLException("Conversion to ascii stream failed");
    }

    public InputStream binaryStreamValue() throws SQLException {
        throw new SQLException("Conversion to binary stream failed");
    }

    public abstract boolean isConvertibleTo(Class<?> var1);

    public <T> T toClass(Class<T> type) throws SQLException {
        if (this.targetDatum != null && type == this.targetDatum.getClass()) {
            return this.targetDatum.toClass(type);
        }
        Object result = null;
        if (type == this.getClass()) {
            result = this;
        } else if (type == String.class) {
            result = this.stringValue();
        } else if (type == Boolean.class) {
            result = this.booleanValue();
        } else if (type == Byte.class) {
            result = this.byteValue();
        } else if (type == Integer.class) {
            result = this.intValue();
        } else if (type == Long.class) {
            result = this.longValue();
        } else if (type == Float.class) {
            result = Float.valueOf(this.floatValue());
        } else if (type == Double.class) {
            result = this.doubleValue();
        } else if (type == BigDecimal.class) {
            result = this.bigDecimalValue();
        } else if (type == Date.class) {
            result = this.dateValue();
        } else if (type == Time.class) {
            result = this.timeValue();
        } else if (type == Timestamp.class) {
            result = this.timestampValue();
        } else if (type == Reader.class) {
            result = this.characterStreamValue();
        } else if (type == InputStream.class) {
            result = this.binaryStreamValue();
        } else {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, type.getName()).fillInStackTrace();
        }
        return (T)result;
    }

    public abstract Object toJdbc() throws SQLException;

    public abstract Object makeJdbcArray(int var1);

    public static int compareBytes(byte[] m, byte[] n) {
        int ml = m.length;
        int nl = n.length;
        int cc = Math.min(ml, nl);
        int um = 0;
        int un = 0;
        for (int cl = 0; cl < cc; ++cl) {
            um = m[cl] & 0xFF;
            un = n[cl] & 0xFF;
            if (um == un) continue;
            if (um < un) {
                return -1;
            }
            return 1;
        }
        if (ml == nl) {
            return 0;
        }
        if (ml > nl) {
            return 1;
        }
        return -1;
    }

    protected boolean bytesEqual(Datum other) {
        byte[] odata;
        boolean nulldata;
        boolean result;
        if (this.targetDatum != null) {
            return this.targetDatum.bytesEqual(other);
        }
        boolean bl = result = this == other;
        if (!result && (nulldata = this.data == null) == ((odata = other.shareBytes()) == null) && (nulldata || this.data.length == odata.length)) {
            result = true;
            if (!nulldata) {
                for (int i = 0; i < this.data.length; ++i) {
                    if (this.data[i] == odata[i]) continue;
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

