/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import oracle.jdbc.internal.OpaqueString;

public final class OpaqueURI {
    private final String scheme;
    private final String authority;
    private final List<Parameter> parameters;

    private OpaqueURI(Builder builder) {
        this.scheme = builder.scheme;
        this.authority = builder.authority;
        ArrayList parameters = new ArrayList(builder.parameters.size());
        parameters.addAll(builder.parameters);
        this.parameters = Collections.unmodifiableList(parameters);
    }

    public char[] toCharArray() {
        int uriLength = 0;
        char[] schemeChars = this.schemeChars();
        uriLength += schemeChars.length;
        char[] authorityChars = this.authorityChars();
        uriLength += authorityChars.length;
        for (Parameter parameter : this.parameters) {
            uriLength += 1 + parameter.length();
        }
        char[] uriChars = new char[uriLength];
        CharBuffer uriCharsBuffer = CharBuffer.wrap(uriChars);
        uriCharsBuffer.put(schemeChars);
        uriCharsBuffer.put(authorityChars);
        if (!this.parameters.isEmpty()) {
            uriCharsBuffer.put('?');
            this.parameters.get(0).copyTo(uriCharsBuffer);
            for (int i = 1; i < this.parameters.size(); ++i) {
                uriCharsBuffer.put('&');
                this.parameters.get(i).copyTo(uriCharsBuffer);
            }
        }
        return uriChars;
    }

    private char[] schemeChars() {
        return this.scheme == null ? new char[]{} : (this.scheme + ":").toCharArray();
    }

    private char[] authorityChars() {
        return this.authority == null ? new char[]{} : ("//" + this.authority).toCharArray();
    }

    public String toString() {
        return this.schemeChars() + this.authorityChars() + (this.parameters.isEmpty() ? "" : "?") + this.parameters.stream().map(Parameter::toString).collect(Collectors.joining("&"));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String scheme = null;
        private String authority = null;
        private List<Parameter> parameters = new ArrayList<Parameter>();

        public Builder scheme(String scheme) {
            this.scheme = Objects.requireNonNull(scheme, "Scheme is null");
            return this;
        }

        public Builder authority(String authority) {
            this.authority = Objects.requireNonNull(authority, "Authority is null");
            return this;
        }

        public Builder optionalParameter(String name, Object value) {
            if (value == null || value instanceof OpaqueString && OpaqueString.isNull((OpaqueString)value)) {
                return this;
            }
            return this.parameter(name, value);
        }

        public Builder parameter(String name, Object value) {
            Objects.requireNonNull(name, "Key is null");
            Objects.requireNonNull(value, "Value is null");
            if (value instanceof OpaqueString) {
                if (OpaqueString.isNull((OpaqueString)value)) {
                    throw new NullPointerException("Value is a null-valued OpaqueString");
                }
                this.parameters.add(new SensitiveParameter(name, (OpaqueString)value));
            } else {
                this.parameters.add(new ClearTextParameter(name, value.toString()));
            }
            return this;
        }

        public OpaqueURI build() {
            return new OpaqueURI(this);
        }
    }

    private static final class ClearTextParameter
    extends Parameter {
        final CharSequence value;

        ClearTextParameter(String name, CharSequence value) {
            super(name);
            this.value = ClearTextParameter.percentEncode(value);
        }

        @Override
        int valueLength() {
            return this.value.length();
        }

        @Override
        void copyValueTo(CharBuffer charBuffer) {
            for (int i = 0; i < this.value.length(); ++i) {
                charBuffer.put(this.value.charAt(i));
            }
        }

        @Override
        public String toString() {
            return this.name + "=" + this.value;
        }
    }

    private static final class SensitiveParameter
    extends Parameter {
        final OpaqueString value;

        SensitiveParameter(String name, OpaqueString value) {
            super(name);
            this.value = value.map(clearText -> OpaqueString.newOpaqueString(SensitiveParameter.percentEncode(CharBuffer.wrap(clearText))));
        }

        @Override
        int valueLength() {
            return this.value.length();
        }

        @Override
        void copyValueTo(CharBuffer charBuffer) {
            this.value.copyTo(charBuffer);
        }

        @Override
        public String toString() {
            return this.name + "=[OMITTED]";
        }
    }

    private static abstract class Parameter {
        final String name;

        protected Parameter(String name) {
            this.name = name;
        }

        final int length() {
            return this.name.length() + "=".length() + this.valueLength();
        }

        final void copyTo(CharBuffer charBuffer) {
            charBuffer.put(this.name).put('=');
            this.copyValueTo(charBuffer);
        }

        abstract int valueLength();

        abstract void copyValueTo(CharBuffer var1);

        public abstract String toString();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static CharSequence percentEncode(CharSequence charSequence) {
            ArrayDeque<ByteBuffer> utf8Encodings = new ArrayDeque<ByteBuffer>(0);
            try {
                int encodedLength = 0;
                for (int i = 0; i < charSequence.length(); ++i) {
                    CharBuffer charBuffer;
                    if (!Parameter.isUriReserved(charSequence.charAt(i))) {
                        ++encodedLength;
                        continue;
                    }
                    if (Character.isHighSurrogate(charSequence.charAt(i)) && i + 1 < charSequence.length()) {
                        charBuffer = CharBuffer.wrap(charSequence, i, i + 2);
                        ++i;
                    } else {
                        charBuffer = CharBuffer.wrap(charSequence, i, i + 1);
                    }
                    ByteBuffer utf8Encoded = StandardCharsets.UTF_8.encode(charBuffer);
                    utf8Encodings.add(utf8Encoded);
                    encodedLength += 2 * utf8Encoded.remaining() + utf8Encoded.remaining();
                }
                if (utf8Encodings.isEmpty()) {
                    CharSequence i = charSequence;
                    return i;
                }
                char[] encoded = new char[encodedLength];
                CharBuffer encodedBuffer = CharBuffer.wrap(encoded);
                for (int i = 0; i < charSequence.length(); ++i) {
                    if (!Parameter.isUriReserved(charSequence.charAt(i))) {
                        encodedBuffer.put(charSequence.charAt(i));
                        continue;
                    }
                    ByteBuffer encoding = (ByteBuffer)utf8Encodings.remove();
                    while (encoding.hasRemaining()) {
                        byte utf8 = encoding.get();
                        encodedBuffer.put('%');
                        encodedBuffer.put(Parameter.toHexDigit((byte)(utf8 >> 4)));
                        encodedBuffer.put(Parameter.toHexDigit(utf8));
                    }
                    encoding.clear();
                    encoding.put(new byte[encoding.remaining()]);
                }
                encodedBuffer.flip();
                CharBuffer charBuffer = encodedBuffer;
                return charBuffer;
            }
            finally {
                while (!utf8Encodings.isEmpty()) {
                    ByteBuffer encoding = (ByteBuffer)utf8Encodings.remove();
                    encoding.put(new byte[encoding.remaining()]);
                }
            }
        }

        private static boolean isUriReserved(char character) {
            if (character >= 'a' && character <= 'z') {
                return false;
            }
            if (character >= 'A' && character <= 'Z') {
                return false;
            }
            if (character >= '0' && character <= '9') {
                return false;
            }
            return character != '-' && character != '.' && character != '_' && character != '~';
        }

        private static char toHexDigit(byte value) {
            byte lowBits = (byte)(value & 0xF);
            return (char)(lowBits < 10 ? 48 + lowBits : 65 + (lowBits - 10));
        }
    }
}

