/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.replay.OracleDataSourceImpl;
import oracle.net.resolver.AddrResolution;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;

class ShardingConnectionUtil {
    private static final String CLASS_NAME = ShardingConnectionUtil.class.getName();
    private static final Monitor shardingConnectionUtilLock = Monitor.newInstance();
    private static final int DB_SHARDING_ENABLED = 1;
    private static final int DB_SHARD_CATALOG = 4;
    static ConcurrentHashMap<Integer, ShardingPoolDataSourceEntry> shardDatabasePoolDataSourceMap = new ConcurrentHashMap();
    static PoolDataSource catalogDatabasePoolDataSource;
    static short dbCharSet;
    static Diagnosable diagnosable;

    ShardingConnectionUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ShardingPoolDataSourceEntry getShardingDatabasePoolDataSource(String url, @Blind(value=PropertiesBlinder.class) Properties info, String gsmServiceName, boolean shardingReplayEnable, String resolvedUrl) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = shardingConnectionUtilLock.acquireCloseableLock();){
            ShardingPoolDataSourceEntry shardingPoolDataSourceEntry;
            block27: {
                ShardingPoolDataSourceEntry shardDatabasePoolDatasourceEntry;
                int key;
                Connection connection;
                block25: {
                    ShardingPoolDataSourceEntry shardingPoolDataSourceEntry2;
                    block26: {
                        connection = null;
                        try {
                            key = ShardingConnectionUtil.calculateConnectionInfoHashKey(url, info);
                            shardDatabasePoolDatasourceEntry = null;
                            if (!shardDatabasePoolDataSourceMap.containsKey(key)) break block25;
                            shardingPoolDataSourceEntry2 = shardDatabasePoolDatasourceEntry = shardDatabasePoolDataSourceMap.get(key);
                            if (connection == null) break block26;
                        }
                        catch (Throwable throwable2) {
                            try {
                                if (connection != null) {
                                    connection.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                        }
                        connection.close();
                    }
                    return shardingPoolDataSourceEntry2;
                }
                PoolDataSource shardDatabasePoolDatasource = PoolDataSourceFactory.getPoolDataSource();
                if (shardingReplayEnable) {
                    shardDatabasePoolDatasource.setConnectionFactoryClassName(OracleDataSourceImpl.class.getName());
                } else {
                    shardDatabasePoolDatasource.setConnectionFactoryClassName(OracleDataSource.class.getName());
                }
                shardDatabasePoolDatasource.setURL(url);
                shardDatabasePoolDatasource.setConnectionProperties(info);
                shardDatabasePoolDatasource.setConnectionWaitTimeout(0);
                shardDatabasePoolDatasource.setInactiveConnectionTimeout(120);
                shardDatabasePoolDatasource.setMaxPoolSize(Integer.MAX_VALUE);
                OracleDataSource ds = new OracleDataSource();
                ds.setURL(url);
                ds.setConnectionProperties(info);
                connection = ds.getConnection();
                ((OracleConnection)connection).addFeature(OracleConnection.ClientFeature.SHARDING_DRIVER);
                short dbver = ((OracleConnection)connection).getVersionNumber();
                if (dbver < 20000) {
                    throw (SQLException)DatabaseError.createSqlException(1710).fillInStackTrace();
                }
                if (catalogDatabasePoolDataSource == null) {
                    dbCharSet = ((OracleConnection)connection).getDbCsId();
                    catalogDatabasePoolDataSource = ShardingConnectionUtil.getCatalogDatabasePoolDataSource(connection, resolvedUrl == null ? url : resolvedUrl, info, gsmServiceName, shardingReplayEnable);
                } else {
                    ShardingConnectionUtil.validateConnectionToShardedDatabase(connection);
                }
                shardDatabasePoolDatasourceEntry = new ShardingPoolDataSourceEntry(shardDatabasePoolDatasource, ((OracleConnection)connection).getUserName(), ((OracleConnection)connection).getCurrentSchema(), ((OracleConnection)connection).getServerSessionInfo());
                shardDatabasePoolDataSourceMap.put(key, shardDatabasePoolDatasourceEntry);
                diagnosable.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "getShardingDatabasePoolDataSource", "create new pool datasource with key={0}", null, null, key);
                shardingPoolDataSourceEntry = shardDatabasePoolDatasourceEntry;
                if (connection == null) break block27;
                connection.close();
            }
            return shardingPoolDataSourceEntry;
        }
    }

    static int calculateConnectionInfoHashKey(String url, @Blind(value=PropertiesBlinder.class) Properties info) {
        int tempHashCode = 1;
        if (url != null) {
            tempHashCode = 31 * tempHashCode + url.hashCode();
        }
        if (info != null) {
            Set<String> keys = info.stringPropertyNames();
            for (String key : keys) {
                String value = info.getProperty(key);
                tempHashCode = 31 * tempHashCode + key.hashCode();
                tempHashCode = 31 * tempHashCode + (value != null ? value.hashCode() : 0);
            }
        }
        return tempHashCode;
    }

    static PoolDataSource getCatalogDatabasePoolDataSource() throws SQLException {
        return catalogDatabasePoolDataSource;
    }

    static short getDbCharsSet() {
        return dbCharSet;
    }

    static PoolDataSource getCatalogDatabasePoolDataSource(Connection connection, String url, @Blind(value=PropertiesBlinder.class) Properties info, String gsmServiceName, boolean shardingReplayEnable) throws SQLException {
        String catalogServiceURL = ShardingConnectionUtil.getCatalogServiceUrl(connection, url, gsmServiceName);
        PoolDataSource pds = PoolDataSourceFactory.getPoolDataSource();
        if (shardingReplayEnable) {
            pds.setConnectionFactoryClassName(OracleDataSourceImpl.class.getName());
        } else {
            pds.setConnectionFactoryClassName(OracleDataSource.class.getName());
        }
        pds.setURL(catalogServiceURL);
        pds.setConnectionProperties(info);
        pds.setConnectionWaitTimeout(0);
        pds.setInactiveConnectionTimeout(120);
        pds.setMaxPoolSize(Integer.MAX_VALUE);
        return pds;
    }

    static String getCatalogServiceUrl(Connection connection, String applicationUrl, String gsmServiceName) throws SQLException {
        String catalogServiceUrl = null;
        String catalogServiceName = null;
        try (CallableStatement cstmt = connection.prepareCall("{call GSMADMIN_INTERNAL.getShardingParams(?,?)}");){
            cstmt.registerOutParameter(1, 2);
            cstmt.registerOutParameter(2, 12);
            cstmt.execute();
            int shardMode = cstmt.getInt(1);
            catalogServiceName = cstmt.getString(2);
            if (catalogServiceName == null) {
                throw (SQLException)DatabaseError.createSqlException(1705).fillInStackTrace();
            }
            if ((shardMode & 4) != 0) {
                throw (SQLException)DatabaseError.createSqlException(1709).fillInStackTrace();
            }
            if ((shardMode & 1) == 0) {
                throw (SQLException)DatabaseError.createSqlException(1705).fillInStackTrace();
            }
        }
        catalogServiceUrl = !catalogServiceName.equals(gsmServiceName) ? ShardingConnectionUtil.replaceGsmServiceNameWithCatalogServiceName(applicationUrl, gsmServiceName, catalogServiceName) : applicationUrl;
        return catalogServiceUrl;
    }

    private static String replaceGsmServiceNameWithCatalogServiceName(String url, String gsmServiceName, String catalogServiceName) {
        String replacedUrl = AddrResolution.replaceServiceNameInUrl(url, gsmServiceName, catalogServiceName);
        diagnosable.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "replaceGsmServiceNameWithCatalogServiceName", "url={0} gsmServiceName={1} catalogServiceName={2} replacedUrl={3}", null, null, url, gsmServiceName, catalogServiceName, replacedUrl);
        return replacedUrl;
    }

    private static void validateConnectionToShardedDatabase(Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery("select GSMADMIN_INTERNAL.GETSHARDINGMODE from dual");){
            if (rs.next()) {
                int shardMode = rs.getInt(1);
                diagnosable.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "validateConnectionToShardedDatabase", "sharding mode={0}", null, null, shardMode);
                if ((shardMode & 4) != 0) {
                    throw (SQLException)DatabaseError.createSqlException(1709).fillInStackTrace();
                }
                if ((shardMode & 1) == 0) {
                    throw (SQLException)DatabaseError.createSqlException(1705).fillInStackTrace();
                }
            }
        }
    }

    static {
        diagnosable = CommonDiagnosable.getInstance();
    }

    protected static final class ShardingPoolDataSourceEntry {
        private PoolDataSource pds;
        private String userName;
        private String schemaName;
        private Properties serverSessionInfo;

        public ShardingPoolDataSourceEntry(PoolDataSource pds, String userName, String schemaName, @Blind(value=PropertiesBlinder.class) Properties serverSessionInfo) {
            this.pds = pds;
            this.userName = userName;
            this.schemaName = schemaName;
            this.serverSessionInfo = serverSessionInfo;
        }

        public PoolDataSource getPds() {
            return this.pds;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        @Blind(value=PropertiesBlinder.class)
        public Properties getServerSessionInfo() {
            return this.serverSessionInfo;
        }
    }
}

