/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.dataengine.VParameterMetadata;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.io.MessageType;
import com.vertica.io.RequestMessage;
import com.vertica.io.VStream;
import com.vertica.util.ClientErrorException;
import com.vertica.util.TypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class CopyDataRequestMessage
extends RequestMessage {
    private static final byte[] COPY_HEADER_SIGNATURE = new byte[]{78, 65, 84, 73, 86, 69, 10, -1, 13, 10, 0};
    private final boolean m_addHeader;
    private final List<ParameterInputValue> m_paramData;
    private final Map<Integer, List<DataWrapper>> m_pushedParamData;
    private final InputStream m_streamData;
    private final int m_numParams;
    private final boolean m_isEmptyBatch;

    public CopyDataRequestMessage(boolean bl, int n, List<ParameterInputValue> list, Map<Integer, List<DataWrapper>> map) {
        this.m_addHeader = bl;
        this.m_numParams = n;
        this.m_paramData = list;
        this.m_pushedParamData = map;
        this.m_streamData = null;
        this.m_isEmptyBatch = this.m_paramData == null && this.m_pushedParamData == null;
    }

    public CopyDataRequestMessage(InputStream inputStream) {
        this.m_streamData = inputStream;
        this.m_addHeader = false;
        this.m_numParams = 0;
        this.m_pushedParamData = null;
        this.m_isEmptyBatch = false;
        this.m_paramData = null;
    }

    @Override
    void send(VStream vStream) throws IOException, ClientErrorException {
        if (this.m_streamData != null) {
            this.sendStreamData(vStream);
        } else {
            this.sendParamData(vStream);
        }
    }

    void sendStreamData(VStream vStream) throws IOException {
        byte[] byArray = vStream.getCopyBuffer();
        int n = 0;
        while (n >= 0) {
            n = this.m_streamData.read(byArray, 0, byArray.length);
            if (n <= 0) continue;
            vStream.SendChar(100);
            vStream.SendInteger4(n + 4);
            vStream.Send(byArray, 0, n);
        }
        this.m_streamData.close();
    }

    void sendParamData(VStream vStream) throws IOException, ClientErrorException {
        int n;
        int n2 = 0;
        int n3 = this.m_numParams / 8 + (this.m_numParams % 8 > 0 ? 1 : 0);
        byte[] byArray = new byte[n3];
        int[] nArray = new int[this.m_numParams];
        ArrayList<List<byte[]>> arrayList = new ArrayList<List<byte[]>>(this.m_isEmptyBatch ? 0 : this.m_paramData.size());
        for (n = 0; !this.m_isEmptyBatch && n < this.m_numParams; ++n) {
            nArray[n] = 0;
            ParameterInputValue parameterInputValue = this.m_paramData.get(n);
            if (!parameterInputValue.isPushed() && parameterInputValue.isNull()) {
                int n4 = (n + 1) % 8;
                int n5 = 1;
                if (n4 > 0) {
                    n5 = (byte)(n5 << 8 - n4);
                }
                int n6 = n / 8;
                byArray[n6] = (byte)(byArray[n6] | n5);
                arrayList.add(null);
                continue;
            }
            List<DataWrapper> list = parameterInputValue.isPushed() && this.m_pushedParamData != null ? this.m_pushedParamData.get(n) : null;
            ParameterMetadata parameterMetadata = parameterInputValue.getMetadata();
            short s = parameterMetadata.getTypeMetadata().getType();
            int n7 = 4;
            n7 = parameterMetadata instanceof VParameterMetadata ? ((VParameterMetadata)parameterMetadata).getServerOID() : TypeUtils.getOIDFromSQLType(s);
            List<byte[]> list2 = TypeUtils.serialize(parameterInputValue, s, n7, vStream.getConnection().getAddTzToTimestampParameters(), list, true);
            if (list2 == null) {
                throw new ClientErrorException("Encoded value should not be null");
            }
            arrayList.add(list2);
            for (int i = 0; i < list2.size(); ++i) {
                int n8 = n;
                nArray[n8] = nArray[n8] + list2.get(i).length;
            }
            n2 += 4 + nArray[n];
        }
        n = 4;
        if (!this.m_isEmptyBatch) {
            n += n2;
            n += 4;
            n += byArray.length;
        }
        if (this.m_addHeader) {
            n += COPY_HEADER_SIGNATURE.length;
            n += 4;
            n += 2;
            ++n;
            n += 2;
            n += 4 * this.m_numParams;
        }
        vStream.SendChar(100);
        vStream.SendInteger4(n);
        if (this.m_addHeader) {
            vStream.Send(COPY_HEADER_SIGNATURE);
            vStream.Send(this.getIntBytes(5 + 4 * this.m_numParams, 4));
            vStream.Send(this.getIntBytes(1, 2));
            vStream.Send(this.getIntBytes(0, 1));
            vStream.Send(this.getIntBytes(this.m_numParams, 2));
            for (int n9 = 0; n9 < this.m_numParams; n9 = (int)((short)(n9 + 1))) {
                vStream.Send(this.getIntBytes(-1, 4));
            }
        }
        if (!this.m_isEmptyBatch) {
            vStream.Send(this.getIntBytes(n2, 4));
            vStream.Send(byArray);
            if (this.m_numParams != arrayList.size()) {
                throw new ClientErrorException("Number of parameters must match row data size");
            }
            for (int i = 0; i < this.m_numParams; ++i) {
                List list = (List)arrayList.get(i);
                if (list == null) continue;
                vStream.Send(this.getIntBytes(nArray[i], 4));
                for (int j = 0; j < list.size(); ++j) {
                    vStream.Send((byte[])list.get(j));
                }
            }
        }
    }

    private byte[] getIntBytes(int n, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)(n >>> n3);
            n3 += 8;
        }
        return byArray;
    }

    @Override
    public MessageType getType() {
        return MessageType.ClientCopyData;
    }
}

