/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.utilities.ExecutionContextStatus;
import com.vertica.dsi.dataengine.utilities.ParameterGeneratedValues;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterOutputValue;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ExecutionContext {
    private ArrayList<ParameterInputValue> m_inputs;
    private ArrayList<ParameterOutputValue> m_outputs;
    private ParameterGeneratedValues m_generatedParams;
    private ExecutionContextStatus m_status;

    protected ExecutionContext(ArrayList<ParameterInputValue> inputs, ArrayList<ParameterOutputValue> outputs) {
        this(inputs, outputs, null);
    }

    protected ExecutionContext(ArrayList<ParameterInputValue> inputs, ArrayList<ParameterOutputValue> outputs, ParameterGeneratedValues generatedParams) {
        this.m_inputs = inputs;
        this.m_outputs = outputs;
        this.m_generatedParams = generatedParams;
        this.m_status = ExecutionContextStatus.NOT_EXECUTED;
    }

    public ExecutionContextStatus getStatus() {
        return this.m_status;
    }

    public void setStatus(ExecutionContextStatus status) {
        if (null == status) {
            throw null;
        }
        this.m_status = status;
    }

    public ArrayList<ParameterInputValue> getInputs() {
        return this.m_inputs;
    }

    public ArrayList<ParameterOutputValue> getOutputs() {
        return this.m_outputs;
    }

    public ParameterGeneratedValues getGeneratedParameters() {
        return this.m_generatedParams;
    }

    public int[] getSelectedGeneratedColumns(List<IColumn> columnMetadata) throws ErrorException {
        return ExecutionContext.getSelectedGeneratedColumns(this.m_generatedParams, columnMetadata);
    }

    public static int[] getSelectedGeneratedColumns(ParameterGeneratedValues generated, List<IColumn> columnMetadata) throws ErrorException {
        assert (null != columnMetadata);
        if (generated == null || Boolean.FALSE.equals(generated.isAutoGeneratedKeys())) {
            return new int[0];
        }
        ArrayList<Integer> generatedColumnsIndexes = new ArrayList<Integer>();
        HashMap<String, Integer> columnNameMap = new HashMap<String, Integer>();
        for (int i = 0; i < columnMetadata.size(); ++i) {
            IColumn col = columnMetadata.get(i);
            if (!col.isAutoUnique()) continue;
            generatedColumnsIndexes.add(i + 1);
            columnNameMap.put(col.getName().toLowerCase(), i + 1);
        }
        if (Boolean.TRUE.equals(generated.isAutoGeneratedKeys())) {
            int[] tmpArray = new int[generatedColumnsIndexes.size()];
            int i = 0;
            Iterator i$ = generatedColumnsIndexes.iterator();
            while (i$.hasNext()) {
                int ci = (Integer)i$.next();
                tmpArray[i++] = ci;
            }
            return tmpArray;
        }
        int[] columnIndexes = generated.getColumnIndexes();
        if (generated.getGeneratedType() == ParameterGeneratedValues.GeneratedType.COLUMN_INDEXES) {
            for (int i = 0; i < columnIndexes.length; ++i) {
                if (Collections.binarySearch(generatedColumnsIndexes, columnIndexes[i]) >= 0) continue;
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), Integer.toString(columnIndexes[i]), ExceptionType.DATA);
            }
            return columnIndexes;
        }
        String[] columnNames = generated.getColumnNames();
        int[] columnNameIndexes = new int[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            Integer colInd = (Integer)columnNameMap.get(columnNames[i].toLowerCase());
            if (colInd == null) {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), columnNames[i], ExceptionType.DATA);
            }
            columnNameIndexes[i] = colInd;
        }
        return columnNameIndexes;
    }

    public void setInputParam(int paramIndex, ParameterInputValue parameterInputValue) {
        this.m_inputs.set(paramIndex, parameterInputValue);
    }
}

